/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.skins.uuidcache;

import de.oliver.fancynpcs.skins.uuidcache.UUIDCache;
import de.oliver.fancynpcs.skins.uuidcache.UUIDCacheData;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class UUIDMemoryCache
implements UUIDCache {
    private final Map<String, UUIDCacheData> cache = new ConcurrentHashMap<String, UUIDCacheData>();

    @Override
    public UUID getUUID(String username) {
        if (!this.cache.containsKey(username)) {
            return null;
        }
        UUIDCacheData data = this.cache.get(username);
        if (data.isExpired()) {
            this.cache.remove(username);
            return null;
        }
        return data.uuid();
    }

    @Override
    public void cacheUUID(String username, UUID uuid) {
        UUIDCacheData data = new UUIDCacheData(username, uuid, System.currentTimeMillis(), 2592000000L);
        this.cache.put(username, data);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }
}

