/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.skins;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancylib.UUIDFetcher;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.skins.SkinData;
import de.oliver.fancynpcs.api.skins.SkinGeneratedEvent;
import de.oliver.fancynpcs.api.skins.SkinLoadException;
import de.oliver.fancynpcs.api.skins.SkinManager;
import de.oliver.fancynpcs.libs.chatcolorhandler.ChatColorHandler;
import de.oliver.fancynpcs.skins.SkinGenerationQueue;
import de.oliver.fancynpcs.skins.SkinGenerationRequest;
import de.oliver.fancynpcs.skins.SkinUtils;
import de.oliver.fancynpcs.skins.cache.SkinCache;
import de.oliver.fancynpcs.skins.cache.SkinCacheData;
import de.oliver.fancynpcs.skins.uuidcache.UUIDCache;
import java.io.File;
import java.net.MalformedURLException;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.mineskin.data.Variant;
import org.mineskin.request.GenerateRequest;
import org.mineskin.request.UploadRequestBuilder;
import org.mineskin.request.UrlRequestBuilder;

public class SkinManagerImpl
implements SkinManager,
Listener {
    public static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setNameFormat("FancyNpcs-Skins-%d").build());
    private final String SKINS_DIRECTORY = "plugins/FancyNpcs/skins/";
    private final UUIDCache uuidCache;
    private final SkinCache fileCache;
    private final SkinCache memCache;
    private final SkinGenerationQueue mojangQueue;
    private final SkinGenerationQueue mineSkinQueue;

    public SkinManagerImpl(UUIDCache uuidCache, SkinCache fileCache, SkinCache memCache, SkinGenerationQueue mojangQueue, SkinGenerationQueue mineSkinQueue) {
        this.uuidCache = uuidCache;
        this.fileCache = fileCache;
        this.memCache = memCache;
        this.mojangQueue = mojangQueue;
        this.mineSkinQueue = mineSkinQueue;
        File skinsDir = new File("plugins/FancyNpcs/skins/");
        if (!skinsDir.exists()) {
            skinsDir.mkdirs();
        }
    }

    @Override
    public SkinData getByIdentifier(String identifier, SkinData.SkinVariant variant) throws SkinLoadException {
        if (SkinUtils.isUUID(identifier)) {
            return this.getByUUID(UUID.fromString(identifier), variant);
        }
        if (SkinUtils.isURL(identifier)) {
            return this.getByURL(identifier, variant);
        }
        if (SkinUtils.isFile(identifier)) {
            return this.getByFile(identifier, variant);
        }
        if (SkinUtils.isPlaceholder(identifier)) {
            String parsed = ChatColorHandler.translate(identifier);
            if (parsed.isBlank() || parsed.equalsIgnoreCase("null") || SkinUtils.isPlaceholder(parsed)) {
                throw new SkinLoadException(SkinLoadException.Reason.INVALID_PLACEHOLDER, "(RAW = '" + identifier + "'; PARSED = '" + parsed + "')");
            }
            return this.getByIdentifier(parsed, variant);
        }
        return this.getByUsername(identifier, variant);
    }

    @Override
    public SkinData getByUUID(UUID uuid, SkinData.SkinVariant variant) {
        SkinData cached = this.tryToGetFromCache(uuid.toString(), variant);
        if (cached != null) {
            return cached;
        }
        this.mojangQueue.add(new SkinGenerationRequest(uuid.toString(), variant));
        return new SkinData(uuid.toString(), variant);
    }

    @Override
    public SkinData getByUsername(String username, SkinData.SkinVariant variant) throws SkinLoadException {
        SkinData cached = this.tryToGetFromCache(username, variant);
        if (cached != null) {
            return cached;
        }
        UUID uuid = this.uuidCache.getUUID(username);
        if (uuid == null) {
            uuid = UUIDFetcher.getUUID(username);
            if (uuid == null) {
                throw new SkinLoadException(SkinLoadException.Reason.INVALID_USERNAME, "(USERNAME = '" + username + "')");
            }
            this.uuidCache.cacheUUID(username, uuid);
        }
        SkinData dataByUUID = this.getByUUID(uuid, variant);
        return new SkinData(username, dataByUUID.getVariant(), dataByUUID.getTextureValue(), dataByUUID.getTextureSignature());
    }

    @Override
    public SkinData getByURL(String url, SkinData.SkinVariant variant) throws SkinLoadException {
        UrlRequestBuilder genReq;
        SkinData cached = this.tryToGetFromCache(url, variant);
        if (cached != null) {
            return cached;
        }
        try {
            genReq = GenerateRequest.url(url);
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SkinLoadException(SkinLoadException.Reason.INVALID_URL, "(URL = '" + url + "')");
        }
        genReq.variant(Variant.valueOf(variant.name()));
        this.mineSkinQueue.add(new SkinGenerationRequest(url, variant, genReq));
        return new SkinData(url, variant);
    }

    @Override
    public SkinData getByFile(String filePath, SkinData.SkinVariant variant) throws SkinLoadException {
        SkinData cached = this.tryToGetFromCache(filePath, variant);
        if (cached != null) {
            return cached;
        }
        File file = new File("plugins/FancyNpcs/skins/" + filePath);
        if (!file.exists()) {
            throw new SkinLoadException(SkinLoadException.Reason.INVALID_FILE, "(FILE = '" + filePath + "')");
        }
        UploadRequestBuilder genReq = GenerateRequest.upload(file);
        genReq.variant(Variant.valueOf(variant.name()));
        this.mineSkinQueue.add(new SkinGenerationRequest(filePath, variant, genReq));
        return new SkinData(filePath, variant);
    }

    @EventHandler
    public void onSkinGenerated(SkinGeneratedEvent event) {
        if (event.getSkin() == null || !event.getSkin().hasTexture()) {
            FancyNpcs.getInstance().getFancyLogger().error("Generated skin has no texture!", new Property[0]);
            return;
        }
        for (Npc npc : FancyNpcs.getInstance().getNpcManager().getAllNpcs()) {
            SkinData skin = npc.getData().getSkinData();
            if (skin == null) continue;
            String id = skin.getParsedIdentifier();
            if (SkinUtils.isUsername(id)) {
                UUID uuid = this.uuidCache.getUUID(id);
                if (uuid == null) {
                    uuid = UUIDFetcher.getUUID(id);
                }
                if (uuid != null) {
                    this.uuidCache.cacheUUID(id, uuid);
                    id = uuid.toString();
                }
            }
            if (!id.equals(event.getId())) continue;
            event.getSkin().setIdentifier(skin.getIdentifier());
            npc.getData().setSkinData(event.getSkin());
            npc.removeForAll();
            npc.spawnForAll();
            FancyNpcs.getInstance().getFancyLogger().info("Updated skin for NPC: " + npc.getData().getName(), new Property[0]);
        }
        this.cacheSkin(event.getSkin());
    }

    private SkinData tryToGetFromCache(String identifier, SkinData.SkinVariant variant) {
        FancyNpcs.getInstance().getFancyLogger().debug("Trying to get skin from mem cache: " + identifier, new Property[0]);
        SkinCacheData data = this.memCache.getSkin(identifier);
        if (data != null) {
            if (data.skinData().getVariant() != variant) {
                FancyNpcs.getInstance().getFancyLogger().debug("Skin variant does not match: " + identifier, new Property[0]);
                return null;
            }
            FancyNpcs.getInstance().getFancyLogger().debug("Found skin from mem cache: " + identifier, new Property[0]);
            return data.skinData();
        }
        FancyNpcs.getInstance().getFancyLogger().debug("Trying to get skin from file cache: " + identifier, new Property[0]);
        data = this.fileCache.getSkin(identifier);
        if (data != null) {
            if (data.skinData().getVariant() != variant) {
                FancyNpcs.getInstance().getFancyLogger().debug("Skin variant does not match: " + identifier, new Property[0]);
                return null;
            }
            FancyNpcs.getInstance().getFancyLogger().debug("Found skin from file cache: " + identifier, new Property[0]);
            this.memCache.addSkin(data.skinData());
            return data.skinData();
        }
        FancyNpcs.getInstance().getFancyLogger().debug("Skin not found in cache: " + identifier, new Property[0]);
        return null;
    }

    public void cacheSkin(SkinData skinData) {
        this.memCache.addSkin(skinData);
        this.fileCache.addSkin(skinData);
    }

    public UUIDCache getUuidCache() {
        return this.uuidCache;
    }

    public SkinCache getFileCache() {
        return this.fileCache;
    }

    public SkinCache getMemCache() {
        return this.memCache;
    }
}

