/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.libs.chatcolorhandler.parsers;

import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.Parser;
import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.Resolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parsers {
    private Map<Parser, Integer> parsers = new HashMap<Parser, Integer>();

    public void register(Parser parser, int priority) {
        this.parsers.put(parser, priority);
        this.parsers = Parsers.sortByValue(this.parsers);
    }

    public String parseString(@NotNull String string, @NotNull Parser.OutputType outputType, @Nullable Player player, @NotNull List<Parser> parsers) {
        for (Parser parser : parsers) {
            try {
                string = parser.parseString(string, outputType, player);
            }
            catch (Throwable e) {
                Bukkit.getLogger().log(Level.WARNING, "[ChatColorHandler] Failed to parse string '%s' through parser '%s: ".formatted(string, parser.getClass().getSimpleName()), e);
            }
        }
        return string;
    }

    public List<Parser> getRegisteredParsers() {
        return this.parsers.keySet().stream().toList();
    }

    public List<Resolver> getRegisteredResolvers() {
        return this.parsers.keySet().stream().map(parser -> {
            Resolver resolver;
            return parser instanceof Resolver ? (resolver = (Resolver)parser) : null;
        }).filter(Objects::nonNull).toList();
    }

    public List<Parser> ofType(@NotNull String type) {
        return this.ofTypes(type);
    }

    public List<Parser> ofTypes(String ... types) {
        return this.parsers.keySet().stream().filter(parser -> {
            for (String type : types) {
                if (!parser.getType().equals(type)) continue;
                return true;
            }
            return false;
        }).toList();
    }

    private static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        list.sort(Map.Entry.comparingByValue());
        Collections.reverse(list);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }
}

