/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.npc;

import de.oliver.cloud.annotations.Argument;
import de.oliver.cloud.annotations.Command;
import de.oliver.cloud.annotations.Permission;
import de.oliver.cloud.annotations.parser.Parser;
import de.oliver.cloud.annotations.suggestion.Suggestions;
import de.oliver.cloud.context.CommandContext;
import de.oliver.cloud.context.CommandInput;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.events.NpcModifyEvent;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public enum TurnToPlayerDistanceCMD {
    INSTANCE;

    private final Translator translator = FancyNpcs.getInstance().getTranslator();
    private final List<String> DISTANCE_SUGGESTIONS = List.of("default");

    @Command(value="npc turn_to_player_distance <npc> <distance>")
    @Permission(value={"fancynpcs.command.npc.turn_to_player_distance"})
    public void onTurnToPlayerDistance(@NotNull CommandSender sender, @NotNull Npc npc, @Argument(parserName="TurnToPlayerDistanceCMD/distance") int distance) {
        if (distance < -1) {
            this.translator.translate("npc_turn_to_player_distance_invalid").send(sender);
            return;
        }
        if (new NpcModifyEvent(npc, NpcModifyEvent.NpcModification.TURN_TO_PLAYER_DISTANCE, distance, sender).callEvent()) {
            npc.getData().setTurnToPlayerDistance(distance);
            if (distance == -1) {
                int defaultDistance = FancyNpcs.getInstance().getFancyNpcConfig().getTurnToPlayerDistance();
                this.translator.translate("npc_turn_to_player_distance_default").replace("npc", npc.getData().getName()).replace("distance", String.valueOf(defaultDistance)).send(sender);
            } else {
                this.translator.translate("npc_turn_to_player_distance_set").replace("npc", npc.getData().getName()).replace("distance", String.valueOf(distance)).send(sender);
            }
        } else {
            this.translator.translate("command_npc_modification_cancelled").send(sender);
        }
    }

    @Parser(name="TurnToPlayerDistanceCMD/distance", suggestions="TurnToPlayerDistanceCMD/distance")
    @NotNull
    public Integer parse(CommandContext<CommandSender> context, CommandInput input) {
        if (input.peekString().equalsIgnoreCase("default")) {
            input.readString();
            return -1;
        }
        return input.readInteger();
    }

    @Suggestions(value="TurnToPlayerDistanceCMD/distance")
    @NotNull
    public List<String> suggest(CommandContext<CommandSender> context, CommandInput input) {
        return this.DISTANCE_SUGGESTIONS;
    }
}

