/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancylib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bukkit.plugin.Plugin;

public class FileUtils {
    public static String getSHA256Checksum(File file) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (FileInputStream fis = new FileInputStream(file);){
                int bytesCount;
                byte[] byteArray = new byte[1024];
                while ((bytesCount = fis.read(byteArray)) != -1) {
                    digest.update(byteArray, 0, bytesCount);
                }
            }
            byte[] hashBytes = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte hashByte : hashBytes) {
                String hex = Integer.toHexString(0xFF & hashByte);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            return "N/A";
        }
    }

    public static File findFirstFileByName(File directory, String name) {
        File[] files = directory.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (!file.getName().toLowerCase().contains(name.toLowerCase())) continue;
            return file;
        }
        return null;
    }

    public String readResource(String name) {
        String string;
        block11: {
            URL url = this.getClass().getClassLoader().getResource(name);
            if (url == null) {
                return null;
            }
            URLConnection connection = null;
            try {
                connection = url.openConnection();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            connection.setUseCaches(false);
            InputStream inputStream = connection.getInputStream();
            try {
                byte[] file_raw = new byte[inputStream.available()];
                inputStream.read(file_raw);
                inputStream.close();
                string = new String(file_raw, StandardCharsets.UTF_8);
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    public void saveFile(Plugin plugin, String name) {
        URL url = this.getClass().getClassLoader().getResource(name);
        if (url == null) {
            return;
        }
        File file = new File(plugin.getDataFolder() + File.separator + name);
        if (file.exists()) {
            return;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        URLConnection connection = null;
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        connection.setUseCaches(false);
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int read;
            InputStream inputStream = connection.getInputStream();
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

