/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.node.parser;

import org.jetbrains.annotations.NotNull;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.command.CommandPermission;
import revxrsal.commands.node.CommandNode;
import revxrsal.commands.node.ParameterNode;
import revxrsal.commands.node.parser.MutableCommandNode;
import revxrsal.commands.node.parser.ParameterNodeImpl;
import revxrsal.commands.parameter.ParameterType;

final class MutableParameterNode<A extends CommandActor, T>
extends MutableCommandNode<A>
implements Comparable<MutableParameterNode<A, Object>> {
    @NotNull
    private ParameterType<A, T> type;
    @NotNull
    private SuggestionProvider<A> suggestions = SuggestionProvider.empty();
    @NotNull
    private CommandPermission<A> permission = CommandPermission.alwaysTrue();
    @NotNull
    private CommandParameter parameter;
    private boolean isOptional;

    public MutableParameterNode(@NotNull String name) {
        super(name);
    }

    @Override
    public int compareTo(@NotNull MutableParameterNode<A, Object> o) {
        return this.type.parsePriority().comparator().compare(this.type(), o.type());
    }

    @NotNull
    public ParameterNode<A, T> createNode() {
        return new ParameterNodeImpl(this.getName(), this.getAction(), this.isLast(), this.type, this.suggestions, this.parameter, this.permission, this.isOptional);
    }

    public void setType(@NotNull ParameterType<A, T> type) {
        this.type = type;
        if (this.suggestions == SuggestionProvider.empty()) {
            this.suggestions = type.defaultSuggestions();
        }
    }

    @Override
    public CommandNode<A> toNode() {
        return this.createNode();
    }

    @NotNull
    public ParameterType<A, T> type() {
        return this.type;
    }

    @NotNull
    public SuggestionProvider<A> suggestions() {
        return this.suggestions;
    }

    @NotNull
    public CommandParameter parameter() {
        return this.parameter;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public void setSuggestions(@NotNull SuggestionProvider<A> suggestions) {
        if (suggestions == null) {
            throw new NullPointerException("suggestions is marked non-null but is null");
        }
        this.suggestions = suggestions;
    }

    public void setPermission(@NotNull CommandPermission<A> permission) {
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        this.permission = permission;
    }

    public void setParameter(@NotNull CommandParameter parameter) {
        if (parameter == null) {
            throw new NullPointerException("parameter is marked non-null but is null");
        }
        this.parameter = parameter;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }
}

