/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancysitula.versions.v1_21_3.packets;

import de.oliver.fancysitula.api.entities.FS_RealPlayer;
import de.oliver.fancysitula.api.packets.FS_ClientboundSetEntityDataPacket;
import de.oliver.fancysitula.api.utils.reflections.ReflectionUtils;
import de.oliver.fancysitula.versions.v1_21_3.utils.VanillaPlayerAdapter;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.inventory.ItemStack;

public class ClientboundSetEntityDataPacketImpl
extends FS_ClientboundSetEntityDataPacket {
    private static final ConcurrentMap<String, Class<?>> ENTITY_CLASS_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<String, EntityDataAccessor<Object>> ENTITY_ACCESSOR_CACHE = new ConcurrentHashMap<String, EntityDataAccessor<Object>>();

    public ClientboundSetEntityDataPacketImpl(int entityId, List<FS_ClientboundSetEntityDataPacket.EntityData> entityData) {
        super(entityId, entityData);
    }

    private static Class<?> getEntityClassCached(String className) throws ClassNotFoundException {
        Class cached = (Class)ENTITY_CLASS_CACHE.get(className);
        if (cached != null) {
            return cached;
        }
        ClassLoader classLoader = MinecraftServer.class.getClassLoader();
        Class<?> resolved = classLoader.loadClass(className);
        ENTITY_CLASS_CACHE.put(className, resolved);
        return resolved;
    }

    private static EntityDataAccessor<Object> getAccessorCached(String entityClassName, String fieldName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        String key = entityClassName + "#" + fieldName;
        EntityDataAccessor cached = (EntityDataAccessor)ENTITY_ACCESSOR_CACHE.get(key);
        if (cached != null) {
            return cached;
        }
        Class<?> entityClass = ClientboundSetEntityDataPacketImpl.getEntityClassCached(entityClassName);
        EntityDataAccessor accessor = (EntityDataAccessor)ReflectionUtils.getStaticField(entityClass, fieldName);
        ENTITY_ACCESSOR_CACHE.put(key, (EntityDataAccessor<Object>)accessor);
        return accessor;
    }

    @Override
    public Object createPacket() {
        ArrayList<SynchedEntityData.DataValue> dataValues = new ArrayList<SynchedEntityData.DataValue>();
        for (FS_ClientboundSetEntityDataPacket.EntityData data : this.entityData) {
            try {
                Holder.Reference holder;
                Registry registry;
                DedicatedServer server;
                ResourceLocation loc;
                Object variantKey;
                Object e2;
                String s;
                Object c;
                String entityClassName = data.getAccessor().entityClassName();
                String accessorFieldName = data.getAccessor().accessorFieldName();
                EntityDataAccessor<Object> accessor = ClientboundSetEntityDataPacketImpl.getAccessorCached(entityClassName, accessorFieldName);
                Object vanillaValue = data.getValue();
                if (data.getValue() == null) continue;
                Object object = data.getValue();
                if (object instanceof Component) {
                    Component c2 = (Component)object;
                    vanillaValue = PaperAdventure.asVanilla((Component)c2);
                }
                if ((object = data.getValue()) instanceof Optional) {
                    Object t;
                    Optional opt = (Optional)object;
                    if (opt.isPresent() && (t = opt.get()) instanceof Component) {
                        c = (Component)t;
                        vanillaValue = Optional.of(PaperAdventure.asVanilla((Component)c));
                    } else {
                        vanillaValue = Optional.empty();
                    }
                }
                if ((c = data.getValue()) instanceof ItemStack) {
                    ItemStack i = (ItemStack)c;
                    vanillaValue = net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)i);
                }
                if ((c = data.getValue()) instanceof BlockState) {
                    BlockState b = (BlockState)c;
                    vanillaValue = ((CraftBlockState)b).getHandle();
                }
                if ((c = data.getValue()) instanceof String) {
                    s = (String)c;
                    if (accessorFieldName.equals("DATA_STATE") && entityClassName.contains("Armadillo")) {
                        try {
                            vanillaValue = Armadillo.ArmadilloState.valueOf((String)s.toUpperCase());
                        }
                        catch (IllegalArgumentException e2) {
                            vanillaValue = Armadillo.ArmadilloState.IDLE;
                        }
                    }
                }
                if ((e2 = data.getValue()) instanceof String) {
                    s = (String)e2;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Wolf")) {
                        variantKey = s.startsWith("wolf:") ? s.substring("wolf:".length()) : s;
                        loc = ResourceLocation.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.WOLF_VARIANT);
                        holder = registry.get(loc).orElse(null);
                        if (holder != null) {
                            vanillaValue = holder;
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Cat")) {
                        variantKey = s.startsWith("cat:") ? s.substring("cat:".length()) : s;
                        loc = ResourceLocation.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.CAT_VARIANT);
                        holder = registry.get(loc).orElse(null);
                        if (holder != null) {
                            vanillaValue = holder;
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Frog")) {
                        variantKey = s.startsWith("frog:") ? s.substring("frog:".length()) : s;
                        loc = ResourceLocation.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.FROG_VARIANT);
                        holder = registry.get(loc).orElse(null);
                        if (holder != null) {
                            vanillaValue = holder;
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VILLAGER_DATA") && entityClassName.contains("Villager")) {
                        String typeKey;
                        Holder.Reference holder2;
                        if (s.contains(",") || s.contains("type:") && s.contains("profession:")) {
                            String[] parts;
                            VillagerType villagerType = VillagerType.PLAINS;
                            VillagerProfession profession = VillagerProfession.NONE;
                            int level = 1;
                            for (String part : parts = s.split(",")) {
                                Holder.Reference holder3;
                                ResourceLocation loc2;
                                if ((part = part.trim()).startsWith("type:")) {
                                    String typeKey2 = part.substring("type:".length());
                                    loc2 = ResourceLocation.parse((String)typeKey2);
                                    holder3 = BuiltInRegistries.VILLAGER_TYPE.get(loc2).orElse(null);
                                    if (holder3 == null) continue;
                                    villagerType = (VillagerType)holder3.value();
                                    continue;
                                }
                                if (part.startsWith("profession:")) {
                                    String profKey = part.substring("profession:".length());
                                    loc2 = ResourceLocation.parse((String)profKey);
                                    holder3 = BuiltInRegistries.VILLAGER_PROFESSION.get(loc2).orElse(null);
                                    if (holder3 == null) continue;
                                    profession = (VillagerProfession)holder3.value();
                                    continue;
                                }
                                if (!part.startsWith("level:")) continue;
                                try {
                                    level = Integer.parseInt(part.substring("level:".length()));
                                    level = Math.max(1, Math.min(5, level));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            vanillaValue = new VillagerData(villagerType, profession, level);
                        } else if (s.startsWith("profession:")) {
                            String profKey = s.substring("profession:".length());
                            loc = ResourceLocation.parse((String)profKey);
                            holder2 = BuiltInRegistries.VILLAGER_PROFESSION.get(loc).orElse(null);
                            if (holder2 != null) {
                                vanillaValue = new VillagerData(VillagerType.PLAINS, (VillagerProfession)holder2.value(), 1);
                            }
                        } else if (s.startsWith("type:") && (holder2 = (Holder.Reference)BuiltInRegistries.VILLAGER_TYPE.get(loc = ResourceLocation.parse((String)(typeKey = s.substring("type:".length())))).orElse(null)) != null) {
                            vanillaValue = new VillagerData((VillagerType)holder2.value(), VillagerProfession.NONE, 1);
                        }
                    }
                }
                dataValues.add(SynchedEntityData.DataValue.create(accessor, (Object)vanillaValue));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return new ClientboundSetEntityDataPacket(this.entityId, dataValues);
    }

    @Override
    public void sendPacketTo(FS_RealPlayer player) {
        ClientboundSetEntityDataPacket packet = (ClientboundSetEntityDataPacket)this.createPacket();
        ServerPlayer vanillaPlayer = VanillaPlayerAdapter.asVanilla(player.getBukkitPlayer());
        vanillaPlayer.connection.send((Packet)packet);
    }
}

