/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.trait.builtin;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.trait.HologramTrait;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitClass;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;

@HologramTraitClass(traitName="multiple_pages_trait")
@ApiStatus.Experimental
public class MultiplePagesTrait
extends HologramTrait {
    private static final Configuration DEFAULT_CONFIG = new Configuration(Mode.CYCLE, 1000L, List.of(new Page(List.of("Page 1", "Line 1", "Line 2")), new Page(List.of("Page 2", "Line 1", "Line 2"))));
    private Configuration config;
    private int currentPageIdx = 0;

    @Override
    public void onAttach() {
        HologramData hologramData = this.hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            throw new IllegalStateException("Hologram must be text hologram to use MultiplePagesTrait");
        }
        TextHologramData td = (TextHologramData)hologramData;
        this.load();
        this.hologramThread.scheduleWithFixedDelay(() -> {
            Page currentPage = this.config.pages().get(this.currentPageIdx);
            td.setText(new ArrayList<String>(currentPage.lines()));
            this.currentPageIdx = switch (this.config.mode().ordinal()) {
                case 1 -> (this.currentPageIdx + 1) % this.config.pages().size();
                case 2 -> (int)(Math.random() * (double)this.config.pages().size());
                default -> this.currentPageIdx;
            };
        }, 0L, this.config.cycleDelay(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void save() {
        try {
            this.storage.set(this.hologram.getData().getName(), this.config);
        }
        catch (IOException e) {
            this.logger.error("Failed to save configuration for MultiplePagesTrait", ThrowableProperty.of(e));
        }
    }

    @Override
    public void load() {
        try {
            this.config = this.storage.get(this.hologram.getData().getName(), Configuration.class);
        }
        catch (IOException e) {
            this.logger.error("Failed to load configuration for MultiplePagesTrait", ThrowableProperty.of(e));
        }
        if (this.config == null) {
            this.config = DEFAULT_CONFIG;
            this.save();
        }
    }

    record Configuration(Mode mode, long cycleDelay, List<Page> pages) {
    }

    record Page(List<String> lines) {
        public void addLine(String line) {
            this.lines.add(line);
        }

        public void removeLine(int index) {
            this.lines.remove(index);
        }
    }

    static enum Mode {
        MANUAL,
        CYCLE,
        RANDOM;

    }
}

