/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.tests.api;

import com.fancyinnovations.fancyholograms.api.HologramController;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.controller.HologramControllerImpl;
import com.fancyinnovations.fancyholograms.tests.mocks.HologramMock;
import de.oliver.plugintests.Expectable;
import de.oliver.plugintests.annotations.FPBeforeEach;
import de.oliver.plugintests.annotations.FPTest;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class HologramControllerTest {
    private HologramController controller;
    private Hologram hologram;
    private int spawnTo;
    private int despawnFrom;

    @FPBeforeEach
    public void setUp(Player player) {
        this.controller = new HologramControllerImpl();
        this.hologram = new HologramMock(new TextHologramData("Test", player.getLocation().clone()), () -> ++this.spawnTo, () -> ++this.despawnFrom, () -> {});
        this.spawnTo = 0;
        this.despawnFrom = 0;
    }

    @FPTest(name="Test showHologramTo")
    public void testShowHologramTo(Player player) {
        this.controller.showHologramTo(this.hologram, player);
        Expectable.expect(this.spawnTo).toBe(1);
        Expectable.expect(this.hologram.isViewer(player)).toBe(true);
        this.controller.showHologramTo(this.hologram, player);
        Expectable.expect(this.spawnTo).toBe(1);
    }

    @FPTest(name="Test hideHologramFrom")
    public void testHideHologramFrom(Player player) {
        this.controller.showHologramTo(this.hologram, player);
        Expectable.expect(this.spawnTo).toBe(1);
        Expectable.expect(this.hologram.isViewer(player)).toBe(true);
        this.hologram.getData().setLocation(new Location(player.getWorld(), 0.0, 10000.0, 0.0));
        this.controller.hideHologramFrom(this.hologram, player);
        Expectable.expect(this.despawnFrom).toBe(1);
        Expectable.expect(this.hologram.isViewer(player)).toBe(false);
        this.controller.hideHologramFrom(this.hologram, player);
        Expectable.expect(this.despawnFrom).toBe(1);
    }
}

