/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.listeners;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.fancyinnovations.fancynpcs.api.events.NpcModifyEvent;
import com.fancyinnovations.fancynpcs.api.events.NpcRemoveEvent;
import de.oliver.fancylib.FancyLib;
import de.oliver.fancylib.MessageHelper;
import java.util.Collection;
import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public final class NpcListener
implements Listener {
    @NotNull
    private final FancyHologramsPlugin plugin;

    public NpcListener(@NotNull FancyHologramsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onRemove(@NotNull NpcRemoveEvent event) {
        this.plugin.getRegistry().getAll().stream().filter(hologram -> event.getNpc().getData().getName().equals(hologram.getData().getLinkedNpcName())).forEach(hologram -> hologram.getData().setLinkedNpcName(null));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onModify(@NotNull NpcModifyEvent event) {
        Collection<Hologram> holograms = this.plugin.getRegistry().getAll();
        switch (event.getModification()) {
            case TYPE: 
            case LOCATION: 
            case SCALE: 
            case ATTRIBUTE: {
                List<Hologram> needsToBeUpdated = holograms.stream().filter(hologram -> event.getNpc().getData().getName().equals(hologram.getData().getLinkedNpcName())).toList();
                FancyLib.getInstance().getScheduler().runTaskLater(null, 1L, () -> needsToBeUpdated.forEach(this.plugin.getControllerImpl()::syncHologramWithNpc));
                break;
            }
            case DISPLAY_NAME: 
            case SHOW_IN_TAB: {
                boolean isLinked = holograms.stream().map(Hologram::getData).map(HologramData::getLinkedNpcName).anyMatch(event.getNpc().getData().getName()::equals);
                if (!isLinked) break;
                event.setCancelled(true);
                MessageHelper.error(event.getModifier(), "This modification is not allowed on a hologram linked npc");
            }
        }
    }
}

