/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.converter;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConverterTarget {
    private static final ConverterTarget ALL = new ConverterTarget(Pattern.compile(".*"));
    @NotNull
    private final Pattern hologramIdRegex;

    public ConverterTarget(@NotNull Pattern matching) {
        this.hologramIdRegex = matching;
    }

    @NotNull
    public static ConverterTarget all() {
        return ALL;
    }

    @NotNull
    public static ConverterTarget ofAll(@NotNull String first, String ... others) {
        StringBuilder builder = new StringBuilder(first);
        if (others.length > 0) {
            builder.append("|");
        }
        builder.append(String.join((CharSequence)"|", others));
        return new ConverterTarget(Pattern.compile(builder.toString()));
    }

    @NotNull
    public static ConverterTarget ofSingle(@NotNull String match) {
        return new ConverterTarget(Pattern.compile(match));
    }

    @Nullable
    public static ConverterTarget ofStringNullable(@NotNull String match) {
        if (match.equalsIgnoreCase("*")) {
            return ConverterTarget.all();
        }
        try {
            return new ConverterTarget(Pattern.compile(match));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @NotNull
    public Pattern getRegex() {
        return this.hologramIdRegex;
    }

    public boolean matches(@NotNull String hologramId) {
        return this.hologramIdRegex.asMatchPredicate().test(hologramId);
    }
}

