/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.config;

import com.fancyinnovations.config.Config;
import com.fancyinnovations.config.ConfigField;
import com.fancyinnovations.fancyholograms.api.HologramConfiguration;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;

public final class FHConfiguration
implements HologramConfiguration {
    public static final String LOG_LEVEL_PATH = "settings.logging.level";
    public static final String MUTE_VERSION_NOTIFICATION_PATH = "settings.logging.version_notification";
    public static final String ENABLE_AUTOSAVE_PATH = "settings.saving.autosave.enabled";
    public static final String AUTOSAVE_INTERVAL_PATH = "settings.saving.autosave.interval";
    public static final String SAVE_ON_CHANGED_PATH = "settings.saving.save_on_changed";
    public static final String VISIBILITY_DISTANCE_PATH = "settings.visibility_distance";
    public static final String REGISTER_COMMANDS_PATH = "settings.register_commands";
    public static final String LANGUAGE_PATH = "settings.language";
    public static final String HOLOGRAM_UPDATE_INTERVAL_PATH = "performance.hologram_update_interval_ms";
    public static final String DISABLE_HOLOGRAMS_FOR_BEDROCK_PLAYERS_PATH = "experimental_features.disable_holograms_for_bedrock_players";
    public static final String DISABLE_HOLOGRAMS_FOR_OLD_CLIENTS = "experimental_features.disable_holograms_for_old_clients";
    public static final String USE_LAMP_COMMANDS = "experimental_features.use_lamp_commands";
    public static final String ENABLE_FOLIA_VISIBILITY_FIX = "experimental_features.enable_folia_visibility_fix";
    private static final String CONFIG_FILE_PATH = "plugins/FancyHolograms/config.yml";
    private Config config;

    public void init() {
        this.config = new Config(FancyHologramsPlugin.get().getFancyLogger(), CONFIG_FILE_PATH);
        this.config.addField(new ConfigField<String>(LOG_LEVEL_PATH, "The log level for the plugin (DEBUG, INFO, WARN, ERROR).", false, "INFO", false, String.class));
        this.config.addField(new ConfigField<Boolean>(MUTE_VERSION_NOTIFICATION_PATH, "Whether version notifications are muted.", false, false, false, Boolean.class));
        this.config.addField(new ConfigField<Boolean>(ENABLE_AUTOSAVE_PATH, "Whether autosave is enabled.", false, true, false, Boolean.class));
        this.config.addField(new ConfigField<Integer>(AUTOSAVE_INTERVAL_PATH, "The interval at which autosave is performed in minutes.", false, 15, false, Integer.class));
        this.config.addField(new ConfigField<Boolean>(SAVE_ON_CHANGED_PATH, "Whether the plugin should save holograms when they are changed.", false, true, false, Boolean.class));
        this.config.addField(new ConfigField<Integer>(VISIBILITY_DISTANCE_PATH, "The default visibility distance for holograms.", false, 20, false, Integer.class));
        this.config.addField(new ConfigField<Boolean>(REGISTER_COMMANDS_PATH, "Whether the plugin should register its commands.", false, true, false, Boolean.class));
        this.config.addField(new ConfigField<String>(LANGUAGE_PATH, "The language to use for the plugin.", false, "default", false, String.class));
        this.config.addField(new ConfigField<Integer>(HOLOGRAM_UPDATE_INTERVAL_PATH, "The interval at which holograms check for text updates (in milliseconds). Lower values = more responsive but higher CPU usage. Recommended: 200-500ms", false, 200, false, Integer.class));
        this.config.addField(new ConfigField<Boolean>(DISABLE_HOLOGRAMS_FOR_BEDROCK_PLAYERS_PATH, "Do not show holograms to bedrock players,", false, false, false, Boolean.class));
        this.config.addField(new ConfigField<Boolean>(DISABLE_HOLOGRAMS_FOR_OLD_CLIENTS, "Do not show holograms to clients with a version older than 1.19.4.", false, false, false, Boolean.class));
        this.config.addField(new ConfigField<Boolean>(USE_LAMP_COMMANDS, "Use the new commands made with the Lamp framework.", false, false, false, Boolean.class));
        this.config.addField(new ConfigField<Boolean>(ENABLE_FOLIA_VISIBILITY_FIX, "When enabled, all holograms will respawn after 100ms when they should spawn", false, false, false, Boolean.class));
        this.config.reload();
    }

    public void reload() {
        this.config.reload();
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public boolean areVersionNotificationsMuted() {
        return (Boolean)this.config.get(MUTE_VERSION_NOTIFICATION_PATH);
    }

    @Override
    public boolean isAutosaveEnabled() {
        return (Boolean)this.config.get(ENABLE_AUTOSAVE_PATH);
    }

    @Override
    public int getAutosaveInterval() {
        return (Integer)this.config.get(AUTOSAVE_INTERVAL_PATH);
    }

    @Override
    public boolean isSaveOnChangedEnabled() {
        return (Boolean)this.config.get(SAVE_ON_CHANGED_PATH);
    }

    @Override
    public int getDefaultVisibilityDistance() {
        return (Integer)this.config.get(VISIBILITY_DISTANCE_PATH);
    }

    @Override
    public boolean isRegisterCommands() {
        return (Boolean)this.config.get(REGISTER_COMMANDS_PATH);
    }

    @Override
    public String getLogLevel() {
        return (String)this.config.get(LOG_LEVEL_PATH);
    }

    @Override
    public String getLanguage() {
        return (String)this.config.get(LANGUAGE_PATH);
    }

    @Override
    public boolean isHologramsForBedrockPlayersEnabled() {
        return (Boolean)this.config.get(DISABLE_HOLOGRAMS_FOR_BEDROCK_PLAYERS_PATH) == false;
    }

    @Override
    public boolean isHologramsForOldClientsEnabled() {
        return (Boolean)this.config.get(DISABLE_HOLOGRAMS_FOR_OLD_CLIENTS) == false;
    }

    @Override
    public boolean useLampCommands() {
        return (Boolean)this.config.get(USE_LAMP_COMMANDS);
    }

    @Override
    public boolean isFoliaVisibilityFixEnabled() {
        return (Boolean)this.config.get(ENABLE_FOLIA_VISIBILITY_FIX);
    }

    public int getHologramUpdateInterval() {
        Integer value = (Integer)this.config.get(HOLOGRAM_UPDATE_INTERVAL_PATH);
        if (value == null || value < 10) {
            return 200;
        }
        return value;
    }
}

