/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.lampCommands.hologram;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.commands.lampCommands.suggestions.SwapLinesSuggestion;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import de.oliver.fancylib.MessageHelper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.Description;
import revxrsal.commands.annotation.SuggestWith;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.annotation.CommandPermission;

public final class SwapLinesCMD {
    public static final SwapLinesCMD INSTANCE = new SwapLinesCMD();

    private SwapLinesCMD() {
    }

    @Command(value={"hologram-new edit <hologram> swapLines <line1> <line2>"})
    @Description(value="Swaps two lines")
    @CommandPermission(value="fancyholograms.hologram.edit.swap_lines")
    public void swapLines(@NotNull BukkitCommandActor actor, @NotNull Hologram hologram, @SuggestWith(value=SwapLinesSuggestion.class) @NotNull int line1, @SuggestWith(value=SwapLinesSuggestion.class) @NotNull int line2) {
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            MessageHelper.error(actor.sender(), "This command can only be used on text holograms");
            return;
        }
        TextHologramData textData = (TextHologramData)hologramData;
        List<String> text = textData.getText();
        if (line1 < 1 || line1 > text.size()) {
            MessageHelper.error(actor.sender(), "First line number is out of range (1-" + text.size() + ")");
            return;
        }
        if (line2 < 1 || line2 > text.size()) {
            MessageHelper.error(actor.sender(), "Second line number is out of range (1-" + text.size() + ")");
            return;
        }
        if (line1 == line2) {
            MessageHelper.warning(actor.sender(), "Cannot swap a line with itself");
            return;
        }
        TextHologramData copied = textData.copy(textData.getName());
        ArrayList<String> newText = new ArrayList<String>(text);
        String temp = (String)newText.get(line1 - 1);
        newText.set(line1 - 1, (String)newText.get(line2 - 1));
        newText.set(line2 - 1, temp);
        copied.setText(newText);
        if (!HologramCMD.callModificationEvent(hologram, actor.sender(), copied, HologramUpdateEvent.HologramModification.TEXT)) {
            return;
        }
        textData.setText(newText);
        if (FancyHologramsPlugin.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHologramsPlugin.get().getStorage().save(hologram.getData());
        }
        MessageHelper.success(actor.sender(), "Swapped line " + line1 + " with line " + line2);
    }
}

