/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.lampCommands.hologram;

import com.fancyinnovations.fancyholograms.api.data.BlockHologramData;
import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.ItemHologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import de.oliver.fancylib.colors.GlowingColor;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancylib.translations.message.SimpleMessage;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.Description;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.annotation.CommandPermission;

public final class GlowingCMD {
    public static final GlowingCMD INSTANCE = new GlowingCMD();
    private final FancyHologramsPlugin plugin = FancyHologramsPlugin.get();
    private final Translator translator = FancyHologramsPlugin.get().getTranslator();

    private GlowingCMD() {
    }

    @Command(value={"hologram-new edit <hologram> glowing"})
    @Description(value="Toggle glowing on/off for item and block holograms")
    @CommandPermission(value="fancyholograms.commands.hologram.glowing")
    public void toggle(@NotNull BukkitCommandActor actor, @NotNull Hologram hologram) {
        DisplayHologramData displayData;
        block8: {
            block7: {
                HologramData hologramData = hologram.getData();
                if (!(hologramData instanceof DisplayHologramData)) break block7;
                displayData = (DisplayHologramData)hologramData;
                if (hologram.getData() instanceof ItemHologramData || hologram.getData() instanceof BlockHologramData) break block8;
            }
            this.translator.translate("commands.hologram.edit.glowing.only_item_block").send(actor.sender());
            return;
        }
        GlowingColor newColor = displayData.getGlowingColor() == GlowingColor.DISABLED ? GlowingColor.WHITE : GlowingColor.DISABLED;
        DisplayHologramData copied = displayData.copy(displayData.getName());
        copied.setGlowingColor(newColor);
        if (!HologramCMD.callModificationEvent(hologram, actor.sender(), copied, HologramUpdateEvent.HologramModification.GLOWING)) {
            return;
        }
        displayData.setGlowingColor(newColor);
        if (this.plugin.getHologramConfiguration().isSaveOnChangedEnabled()) {
            this.plugin.getStorage().save(hologram.getData());
        }
        if (newColor == GlowingColor.DISABLED) {
            this.translator.translate("commands.hologram.edit.glowing.disabled").replace("hologram", hologram.getData().getName()).send(actor.sender());
        } else {
            this.translator.translate("commands.hologram.edit.glowing.enabled").replace("hologram", hologram.getData().getName()).replace("color", ((SimpleMessage)this.translator.translate(newColor.getTranslationKey())).getMessage()).send(actor.sender());
        }
    }

    @Command(value={"hologram-new edit <hologram> glowing <color>"})
    @Description(value="Set glowing color for item and block holograms")
    @CommandPermission(value="fancyholograms.commands.hologram.glowing")
    public void setColor(@NotNull BukkitCommandActor actor, @NotNull Hologram hologram, @NotNull GlowingColor color) {
        DisplayHologramData displayData;
        block10: {
            block9: {
                HologramData hologramData = hologram.getData();
                if (!(hologramData instanceof DisplayHologramData)) break block9;
                displayData = (DisplayHologramData)hologramData;
                if (hologram.getData() instanceof ItemHologramData || hologram.getData() instanceof BlockHologramData) break block10;
            }
            this.translator.translate("commands.hologram.edit.glowing.only_item_block").send(actor.sender());
            return;
        }
        if (color == GlowingColor.DISABLED) {
            copied = displayData.copy(displayData.getName());
            copied.setGlowingColor(GlowingColor.DISABLED);
            if (!HologramCMD.callModificationEvent(hologram, actor.sender(), copied, HologramUpdateEvent.HologramModification.GLOWING)) {
                return;
            }
            displayData.setGlowingColor(GlowingColor.DISABLED);
            if (this.plugin.getHologramConfiguration().isSaveOnChangedEnabled()) {
                this.plugin.getStorage().save(hologram.getData());
            }
            this.translator.translate("commands.hologram.edit.glowing.disabled").replace("hologram", hologram.getData().getName()).send(actor.sender());
        } else {
            copied = displayData.copy(displayData.getName());
            copied.setGlowingColor(color);
            if (!HologramCMD.callModificationEvent(hologram, actor.sender(), copied, HologramUpdateEvent.HologramModification.GLOWING)) {
                return;
            }
            displayData.setGlowingColor(color);
            if (this.plugin.getHologramConfiguration().isSaveOnChangedEnabled()) {
                this.plugin.getStorage().save(hologram.getData());
            }
            this.translator.translate("commands.hologram.edit.glowing.color_set").replace("hologram", hologram.getData().getName()).replace("color", ((SimpleMessage)this.translator.translate(color.getTranslationKey())).getMessage()).send(actor.sender());
        }
    }
}

