/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.hologram;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.commands.Subcommand;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.google.common.primitives.Ints;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisibilityDistanceCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        if (!player.hasPermission("fancyholograms.hologram.edit.visibility_distance")) {
            MessageHelper.error(player, "You don't have the required permission to edit a hologram");
            return false;
        }
        Integer visibilityDistance = Ints.tryParse((String)args[3]);
        if (visibilityDistance == null) {
            MessageHelper.error(player, "Could not parse visibility distance");
            return false;
        }
        if (visibilityDistance <= 0) {
            visibilityDistance = -1;
        }
        if (Ints.compare((int)visibilityDistance, (int)hologram.getData().getVisibilityDistance()) == 0) {
            MessageHelper.warning(player, "This hologram already has this visibility distance");
            return false;
        }
        HologramData copied = hologram.getData().copy(hologram.getData().getName());
        copied.setVisibilityDistance(visibilityDistance);
        if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.UPDATE_VISIBILITY_DISTANCE)) {
            return false;
        }
        if (Ints.compare((int)copied.getVisibilityDistance(), (int)hologram.getData().getVisibilityDistance()) == 0) {
            MessageHelper.warning(player, "This hologram already has this visibility distance");
            return false;
        }
        hologram.getData().setVisibilityDistance(copied.getVisibilityDistance());
        if (FancyHologramsPlugin.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHologramsPlugin.get().getStorage().save(hologram.getData());
        }
        MessageHelper.success(player, "Changed visibility distance");
        return true;
    }
}

