/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.api.trait;

import com.fancyinnovations.fancyholograms.api.FancyHolograms;
import com.fancyinnovations.fancyholograms.api.HologramController;
import com.fancyinnovations.fancyholograms.api.HologramRegistry;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitClass;
import de.oliver.fancyanalytics.logger.ExtendedFancyLogger;
import de.oliver.jdb.JDB;
import java.util.concurrent.ScheduledExecutorService;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class HologramTrait {
    protected final FancyHolograms api = FancyHolograms.get();
    protected final ExtendedFancyLogger logger = this.api.getFancyLogger();
    protected final HologramController controller = this.api.getController();
    protected final HologramRegistry registry = this.api.getRegistry();
    protected final ScheduledExecutorService hologramThread = this.api.getHologramThread();
    protected Hologram hologram;
    protected JDB storage;

    @ApiStatus.Internal
    public final void attachHologram(Hologram hologram) {
        if (this.hologram != null) {
            throw new IllegalStateException("Trait is already attached to a hologram");
        }
        this.hologram = hologram;
        this.storage = new JDB("plugins/FancyHolograms/data/traits/" + this.getName());
        this.onAttach();
    }

    public void onAttach() {
    }

    public void onSpawn(Player player) {
    }

    public void onDespawn(Player player) {
    }

    public void onUpdate(Player player) {
    }

    public void onModify() {
    }

    public void onRegister() {
    }

    public void onUnregister() {
    }

    public void load() {
    }

    public void save() {
    }

    public final String getName() {
        if (this.getClass().isAnnotationPresent(HologramTraitClass.class)) {
            return this.getClass().getAnnotation(HologramTraitClass.class).traitName();
        }
        throw new IllegalArgumentException("Trait class " + String.valueOf(this.getClass()) + " is not annotated with HologramTraitClass");
    }

    public final boolean isTraitAttached(Class<? extends HologramTrait> trait) {
        for (HologramTrait hologramTrait : this.hologram.getData().getTraitTrait().getTraits()) {
            if (!hologramTrait.getClass().equals(trait)) continue;
            return true;
        }
        return false;
    }

    public final <T extends HologramTrait> T getTrait(Class<T> trait) {
        for (HologramTrait hologramTrait : this.hologram.getData().getTraitTrait().getTraits()) {
            if (!hologramTrait.getClass().equals(trait)) continue;
            return (T)hologramTrait;
        }
        return null;
    }

    public final Hologram getHologram() {
        return this.hologram;
    }
}

