/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.api.data.builder;

import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.data.builder.HologramBuilder;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.TextDisplay;

public class TextHologramBuilder
extends HologramBuilder {
    private TextHologramBuilder(String name, Location location) {
        this.data = new TextHologramData(name, location);
    }

    public static TextHologramBuilder create(String name, Location location) {
        return new TextHologramBuilder(name, location);
    }

    public TextHologramBuilder text(List<String> text) {
        ((TextHologramData)this.data).setText(text);
        return this;
    }

    public TextHologramBuilder text(String text) {
        return this.text(List.of(text));
    }

    public TextHologramBuilder text(String ... text) {
        return this.text(List.of(text));
    }

    public TextHologramBuilder background(Color background) {
        ((TextHologramData)this.data).setBackground(background);
        return this;
    }

    public TextHologramBuilder background(String background) {
        int argb = Integer.parseInt(background.substring(1), 16);
        return this.background(Color.fromARGB((int)argb));
    }

    public TextHologramBuilder textAlignment(TextDisplay.TextAlignment textAlignment) {
        ((TextHologramData)this.data).setTextAlignment(textAlignment);
        return this;
    }

    public TextHologramBuilder textShadow(boolean textShadow) {
        ((TextHologramData)this.data).setTextShadow(textShadow);
        return this;
    }

    public TextHologramBuilder seeThrough(boolean seeThrough) {
        ((TextHologramData)this.data).setSeeThrough(seeThrough);
        return this;
    }

    public TextHologramBuilder updateTextInterval(int updateTextInterval) {
        ((TextHologramData)this.data).setTextUpdateInterval(updateTextInterval);
        return this;
    }
}

