/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.api.data;

import com.fancyinnovations.fancyholograms.api.FancyHolograms;
import com.fancyinnovations.fancyholograms.api.data.YamlData;
import com.fancyinnovations.fancyholograms.api.data.property.Visibility;
import com.fancyinnovations.fancyholograms.api.hologram.HologramType;
import com.fancyinnovations.fancyholograms.api.trait.HologramTrait;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitTrait;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HologramData
implements YamlData {
    public static final int DEFAULT_VISIBILITY_DISTANCE = -1;
    public static final Visibility DEFAULT_VISIBILITY = Visibility.ALL;
    public static final boolean DEFAULT_IS_VISIBLE = true;
    public static final boolean DEFAULT_PERSISTENCE = true;
    @NotNull
    protected final HologramTraitTrait traitTrait;
    private final String name;
    private final HologramType type;
    private String filePath;
    private Location location;
    private String worldName;
    private boolean hasChanges = false;
    private Runnable onModify;
    private int visibilityDistance = -1;
    private Visibility visibility = DEFAULT_VISIBILITY;
    private boolean persistent = true;
    private String linkedNpcName;

    public HologramData(String name, HologramType type, Location location) {
        this.name = name;
        this.type = type;
        this.location = location;
        this.worldName = location != null && location.getWorld() != null ? location.getWorld().getName() : null;
        this.traitTrait = new HologramTraitTrait();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public HologramType getType() {
        return this.type;
    }

    @ApiStatus.Internal
    public String getFilePath() {
        return this.filePath;
    }

    @ApiStatus.Internal
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @NotNull
    public Location getLocation() {
        return this.location.clone();
    }

    public HologramData setLocation(@Nullable Location location) {
        if (location == null) {
            this.location = null;
            this.worldName = null;
        } else {
            this.location = location.clone();
            if (this.location.getWorld() == null) {
                this.worldName = null;
            }
        }
        this.setHasChanges(true);
        return this;
    }

    public String getWorldName() {
        return this.worldName;
    }

    @ApiStatus.Internal
    public HologramData setWorldName(String worldName) {
        World world;
        this.worldName = worldName;
        if (this.location != null && (world = Bukkit.getWorld((String)worldName)) != null) {
            this.location.setWorld(world);
        }
        this.setHasChanges(true);
        return this;
    }

    @ApiStatus.Internal
    public HologramData setWorld(World world) {
        if (this.location == null) {
            this.location = new Location(world, 0.0, 0.0, 0.0);
        } else {
            this.location.setWorld(world);
        }
        this.setHasChanges(true);
        return this;
    }

    @ApiStatus.Internal
    public final boolean hasChanges() {
        return this.hasChanges;
    }

    @ApiStatus.Internal
    public final void setHasChanges(boolean hasChanges) {
        this.hasChanges = hasChanges;
        if (hasChanges && this.onModify != null) {
            this.onModify.run();
        }
    }

    @ApiStatus.Internal
    public void setOnModify(Runnable onModify) {
        this.onModify = onModify;
    }

    public int getVisibilityDistance() {
        if (this.visibilityDistance > 0) {
            return this.visibilityDistance;
        }
        return FancyHolograms.get().getHologramConfiguration().getDefaultVisibilityDistance();
    }

    public HologramData setVisibilityDistance(int visibilityDistance) {
        this.visibilityDistance = visibilityDistance;
        this.setHasChanges(true);
        return this;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public HologramData setVisibility(@NotNull Visibility visibility) {
        if (!Objects.equals((Object)this.visibility, (Object)visibility)) {
            this.visibility = visibility;
            this.setHasChanges(true);
            if (this.visibility.equals((Object)Visibility.MANUAL)) {
                Visibility.ManualVisibility.clear();
            }
        }
        return this;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public HologramData setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public String getLinkedNpcName() {
        return this.linkedNpcName;
    }

    public HologramData setLinkedNpcName(String linkedNpcName) {
        if (!Objects.equals(this.linkedNpcName, linkedNpcName)) {
            this.linkedNpcName = linkedNpcName;
            this.setHasChanges(true);
        }
        return this;
    }

    @ApiStatus.Experimental
    @NotNull
    public HologramTraitTrait getTraitTrait() {
        return this.traitTrait;
    }

    @ApiStatus.Experimental
    public HologramData addTrait(HologramTrait trait) {
        this.traitTrait.addTrait(trait);
        return this;
    }

    @ApiStatus.Experimental
    public HologramData addTrait(Class<? extends HologramTrait> traitClass) {
        HologramTrait trait = null;
        try {
            trait = traitClass.getConstructor(null).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            FancyHolograms.get().getFancyLogger().error("Failed to instantiate trait " + traitClass.getSimpleName(), ThrowableProperty.of(e));
        }
        this.traitTrait.addTrait(trait);
        return this;
    }

    @Override
    @ApiStatus.Internal
    public boolean read(ConfigurationSection section, String name) {
        String worldName = section.getString("location.world", "world");
        float x = (float)section.getDouble("location.x", 0.0);
        float y = (float)section.getDouble("location.y", 0.0);
        float z = (float)section.getDouble("location.z", 0.0);
        float yaw = (float)section.getDouble("location.yaw", 0.0);
        float pitch = (float)section.getDouble("location.pitch", 0.0);
        World world = Bukkit.getWorld((String)worldName);
        this.location = new Location(world, (double)x, (double)y, (double)z, yaw, pitch);
        this.visibilityDistance = section.getInt("visibility_distance", -1);
        this.visibility = Optional.ofNullable(section.getString("visibility")).flatMap(Visibility::byString).orElseGet(() -> {
            boolean visibleByDefault = section.getBoolean("visible_by_default", true);
            return visibleByDefault ? Visibility.ALL : Visibility.PERMISSION_REQUIRED;
        });
        this.linkedNpcName = section.getString("linkedNpc");
        return true;
    }

    @Override
    @ApiStatus.Internal
    public boolean write(ConfigurationSection section, String name) {
        section.set("type", (Object)this.type.name());
        section.set("location.world", (Object)this.location.getWorld().getName());
        section.set("location.x", (Object)this.location.x());
        section.set("location.y", (Object)this.location.y());
        section.set("location.z", (Object)this.location.z());
        section.set("location.yaw", (Object)Float.valueOf(this.location.getYaw()));
        section.set("location.pitch", (Object)Float.valueOf(this.location.getPitch()));
        section.set("visibility_distance", (Object)this.visibilityDistance);
        section.set("visibility", (Object)this.visibility.name());
        section.set("persistent", (Object)this.persistent);
        section.set("linkedNpc", (Object)this.linkedNpcName);
        return true;
    }

    public HologramData copy(String name) {
        return new HologramData(name, this.type, this.getLocation()).setVisibilityDistance(this.getVisibilityDistance()).setVisibility(this.getVisibility()).setPersistent(this.isPersistent()).setLinkedNpcName(this.getLinkedNpcName());
    }
}

