/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyanalytics.logger.appender;

import de.oliver.fancyanalytics.logger.LogEntry;
import de.oliver.fancyanalytics.logger.appender.Appender;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.jetbrains.annotations.NotNull;

public class ConsoleAppender
implements Appender {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final PrintStream out;
    @NotNull
    private final String format;

    public ConsoleAppender(@NotNull String format) {
        this.format = format;
        this.out = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                System.out.write(b);
            }
        });
    }

    public ConsoleAppender() {
        this("[{loggerName}] {timestamp} {logLevel}: {message}");
    }

    @Override
    public void append(LogEntry logEntry) {
        Object message = this.format;
        message = ((String)message).replace("{loggerName}", logEntry.loggerName());
        message = ((String)message).replace("{timestamp}", sdf.format(logEntry.timestamp()));
        message = ((String)message).replace("{threadName}", logEntry.properties().get("thread_name").toString());
        message = ((String)message).replace("{logLevel}", logEntry.logLevel().name());
        message = ((String)message).replace("{message}", logEntry.message());
        if (logEntry.properties().get("throwable") != null) {
            message = (String)message + " | Exception: " + logEntry.properties().get("throwable");
        }
        this.out.println((String)message);
    }

    @Override
    public void close() {
    }
}

