/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.tests.api;

import com.fancyinnovations.fancyholograms.api.HologramRegistry;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.registry.HologramRegistryImpl;
import com.fancyinnovations.fancyholograms.tests.mocks.HologramMock;
import de.oliver.plugintests.Expectable;
import de.oliver.plugintests.annotations.FPBeforeEach;
import de.oliver.plugintests.annotations.FPTest;
import java.util.Optional;
import org.bukkit.entity.Player;

public class HologramRegistryTest {
    private HologramRegistry registry;

    @FPBeforeEach
    public void setUp(Player player) {
        this.registry = new HologramRegistryImpl();
    }

    @FPTest(name="Register hologram to registry")
    public void testRegister(Player player) {
        HologramMock hologram = new HologramMock(new TextHologramData("Test", player.getLocation()), () -> {}, () -> {}, () -> {});
        this.registry.register(hologram);
        Optional<Hologram> got = this.registry.get("Test");
        Expectable.expect(got.isPresent()).toBe(true);
        Expectable.expect(got.get()).toEqual(hologram);
    }

    @FPTest(name="Unregister hologram from registry")
    public void testUnregister(Player player) {
        HologramMock hologram = new HologramMock(new TextHologramData("Test", player.getLocation()), () -> {}, () -> {}, () -> {});
        this.registry.register(hologram);
        Expectable.expect(this.registry.get("Test").isPresent()).toBe(true);
        this.registry.unregister(hologram);
        Optional<Hologram> got = this.registry.get("Test");
        Expectable.expect(got.isPresent()).toBe(false);
    }

    @FPTest(name="Check if hologram exists in registry")
    public void testContains(Player player) {
        HologramMock hologram = new HologramMock(new TextHologramData("Test", player.getLocation()), () -> {}, () -> {}, () -> {});
        this.registry.register(hologram);
        Expectable.expect(this.registry.contains("Test")).toBe(true);
    }

    @FPTest(name="Retrieve hologram from registry")
    public void testGet(Player player) {
        HologramMock hologram = new HologramMock(new TextHologramData("Test", player.getLocation()), () -> {}, () -> {}, () -> {});
        this.registry.register(hologram);
        Optional<Hologram> got = this.registry.get("Test");
        Expectable.expect(got.isPresent()).toBe(true);
        Expectable.expect(got.get()).toEqual(hologram);
    }

    @FPTest(name="Retrieve all holograms from registry")
    public void testGetAll(Player player) {
        HologramMock hologram1 = new HologramMock(new TextHologramData("Test1", player.getLocation()), () -> {}, () -> {}, () -> {});
        HologramMock hologram2 = new HologramMock(new TextHologramData("Test2", player.getLocation()), () -> {}, () -> {}, () -> {});
        this.registry.register(hologram1);
        this.registry.register(hologram2);
        Expectable.expect(this.registry.getAll().size()).toBe(2);
        Expectable.expect(this.registry.getAll().contains(hologram1)).toBe(true);
        Expectable.expect(this.registry.getAll().contains(hologram2)).toBe(true);
    }

    @FPTest(name="Retrieve all persistent holograms from registry")
    public void testGetAllPersistent(Player player) {
        HologramMock hologram1 = new HologramMock(new TextHologramData("Test1", player.getLocation()), () -> {}, () -> {}, () -> {});
        TextHologramData data2 = new TextHologramData("Test2", player.getLocation());
        data2.setPersistent(false);
        HologramMock hologram2 = new HologramMock(data2, () -> {}, () -> {}, () -> {});
        this.registry.register(hologram1);
        this.registry.register(hologram2);
        Expectable.expect(this.registry.getAllPersistent()).toHaveLength(1);
        Expectable.expect(this.registry.getAllPersistent().contains(hologram1)).toBe(true);
        Expectable.expect(this.registry.getAllPersistent().contains(hologram2)).toBe(false);
    }

    @FPTest(name="Retrieve hologram from registry, ensuring it exists")
    public void testMustGet(Player player) {
        HologramMock hologram = new HologramMock(new TextHologramData("Test", player.getLocation()), () -> {}, () -> {}, () -> {});
        this.registry.register(hologram);
        Expectable.expect(this.registry.mustGet("Test")).toBeDefined();
        try {
            this.registry.mustGet("NonExistent");
        }
        catch (IllegalArgumentException e) {
            Expectable.expect(e).toBeDefined();
        }
    }
}

