/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.converter;

import com.fancyinnovations.fancyholograms.converter.DecentHologramsConverter;
import com.fancyinnovations.fancyholograms.converter.HologramConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FHConversionRegistry {
    private static final Map<String, HologramConverter> converters = new HashMap<String, HologramConverter>();

    public static void registerBuiltInConverters() {
        FHConversionRegistry.register(new DecentHologramsConverter());
    }

    public static boolean register(HologramConverter converter) {
        return converters.putIfAbsent(converter.getId(), converter) != null;
    }

    @NotNull
    public static Optional<HologramConverter> getConverterById(@NotNull String id) {
        return Optional.ofNullable(converters.get(id));
    }

    @NotNull
    public static <T extends HologramConverter> Optional<T> getConverter(@NotNull String id) {
        return FHConversionRegistry.getConverterById(id).map(converter -> {
            try {
                return converter;
            }
            catch (ClassCastException ignored) {
                return null;
            }
        });
    }

    @NotNull
    public static <T extends HologramConverter> Optional<T> getConverter(@NotNull Class<T> clazz) {
        return converters.values().stream().filter(clazz::isInstance).findFirst().map(converter -> {
            try {
                return converter;
            }
            catch (ClassCastException ignored) {
                return null;
            }
        });
    }

    @NotNull
    public static Set<String> getAllConverterIds() {
        return converters.keySet();
    }

    @NotNull
    public static Set<String> getAllUsableConverterIds() {
        return converters.entrySet().stream().filter(entry -> ((HologramConverter)entry.getValue()).canRunConverter()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

