/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.lampCommands.hologram;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.commands.lampCommands.suggestions.MoveLineDownSuggestion;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import de.oliver.fancylib.MessageHelper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.Description;
import revxrsal.commands.annotation.SuggestWith;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.annotation.CommandPermission;

public final class MoveDownCMD {
    public static final MoveDownCMD INSTANCE = new MoveDownCMD();

    private MoveDownCMD() {
    }

    @Command(value={"hologram-new edit <hologram> moveLineDown <line>"})
    @Description(value="Moves a line down by one position")
    @CommandPermission(value="fancyholograms.hologram.edit.move_line")
    public void moveLineDown(@NotNull BukkitCommandActor actor, @NotNull Hologram hologram, @SuggestWith(value=MoveLineDownSuggestion.class) @NotNull int line) {
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            MessageHelper.error(actor.sender(), "This command can only be used on text holograms");
            return;
        }
        TextHologramData textData = (TextHologramData)hologramData;
        List<String> text = textData.getText();
        if (line < 1 || line > text.size()) {
            MessageHelper.error(actor.sender(), "Line number is out of range (1-" + text.size() + ")");
            return;
        }
        if (line == text.size()) {
            MessageHelper.warning(actor.sender(), "The last line cannot be moved down");
            return;
        }
        TextHologramData copied = textData.copy(textData.getName());
        ArrayList<String> newText = new ArrayList<String>(text);
        String temp = (String)newText.get(line - 1);
        newText.set(line - 1, (String)newText.get(line));
        newText.set(line, temp);
        copied.setText(newText);
        if (!HologramCMD.callModificationEvent(hologram, actor.sender(), copied, HologramUpdateEvent.HologramModification.TEXT)) {
            return;
        }
        textData.setText(newText);
        if (FancyHologramsPlugin.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHologramsPlugin.get().getStorage().save(hologram.getData());
        }
        MessageHelper.success(actor.sender(), "Moved line " + line + " down to position " + (line + 1));
    }
}

