/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.hologram;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.commands.Subcommand;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextShadowCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        Boolean enabled;
        if (!player.hasPermission("fancyholograms.hologram.edit.text_shadow")) {
            MessageHelper.error(player, "You don't have the required permission to edit a hologram");
            return false;
        }
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            MessageHelper.error(player, "This command can only be used on text holograms");
            return false;
        }
        TextHologramData textData = (TextHologramData)hologramData;
        switch (args[3].toLowerCase(Locale.ROOT)) {
            case "true": {
                Boolean bl = true;
                break;
            }
            case "false": {
                Boolean bl = false;
                break;
            }
            default: {
                Boolean bl = enabled = null;
            }
        }
        if (enabled == null) {
            MessageHelper.error(player, "Could not parse text shadow flag");
            return false;
        }
        if (enabled.booleanValue() == textData.hasTextShadow()) {
            MessageHelper.warning(player, "This hologram already has text shadow " + (enabled != false ? "enabled" : "disabled"));
            return false;
        }
        TextHologramData copied = textData.copy(textData.getName());
        copied.setTextShadow(enabled);
        if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.TEXT_SHADOW)) {
            return false;
        }
        if (enabled.booleanValue() == textData.hasTextShadow()) {
            MessageHelper.warning(player, "This hologram already has text shadow " + (enabled != false ? "enabled" : "disabled"));
            return false;
        }
        textData.setTextShadow(copied.hasTextShadow());
        if (FancyHologramsPlugin.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHologramsPlugin.get().getStorage().save(hologram.getData());
        }
        MessageHelper.success(player, "Changed text shadow");
        return true;
    }
}

