/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.hologram;

import com.fancyinnovations.fancyholograms.api.data.BlockHologramData;
import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.ItemHologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.commands.Subcommand;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import de.oliver.fancylib.MessageHelper;
import de.oliver.fancylib.colors.GlowingColor;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancylib.translations.message.SimpleMessage;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlowingCMD
implements Subcommand {
    private final FancyHologramsPlugin plugin = FancyHologramsPlugin.get();
    private final Translator translator = FancyHologramsPlugin.get().getTranslator();

    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        DisplayHologramData displayData;
        block11: {
            block10: {
                if (!player.hasPermission("fancyholograms.hologram.edit.glowing")) {
                    MessageHelper.error(player, "You don't have the required permission to edit a hologram");
                    return false;
                }
                HologramData hologramData = hologram.getData();
                if (!(hologramData instanceof DisplayHologramData)) break block10;
                displayData = (DisplayHologramData)hologramData;
                if (hologram.getData() instanceof ItemHologramData || hologram.getData() instanceof BlockHologramData) break block11;
            }
            this.translator.translate("commands.hologram.edit.glowing.only_item_block").send(player);
            return false;
        }
        String colorStr = args[3];
        GlowingColor color = GlowingColor.valueOf(colorStr.toUpperCase());
        if (color == GlowingColor.DISABLED) {
            DisplayHologramData copied = displayData.copy(displayData.getName());
            copied.setGlowingColor(GlowingColor.DISABLED);
            if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.GLOWING)) {
                return false;
            }
            displayData.setGlowingColor(GlowingColor.DISABLED);
            if (this.plugin.getHologramConfiguration().isSaveOnChangedEnabled()) {
                this.plugin.getStorage().save(hologram.getData());
            }
            this.translator.translate("commands.hologram.edit.glowing.disabled").replace("hologram", hologram.getData().getName()).send(player);
        } else {
            DisplayHologramData copied = displayData.copy(displayData.getName());
            copied.setGlowingColor(color);
            if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.GLOWING)) {
                return false;
            }
            displayData.setGlowingColor(color);
            if (this.plugin.getHologramConfiguration().isSaveOnChangedEnabled()) {
                this.plugin.getStorage().save(hologram.getData());
            }
            this.translator.translate("commands.hologram.edit.glowing.color_set").replace("hologram", hologram.getData().getName()).replace("color", ((SimpleMessage)this.translator.translate(color.getTranslationKey())).getMessage()).send(player);
        }
        return true;
    }
}

