/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands;

import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.api.hologram.HologramType;
import com.fancyinnovations.fancyholograms.commands.hologram.AddLineCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.BackgroundCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.BillboardCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.BlockCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.BrightnessCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.CenterCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.CopyCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.CreateCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.GlowingCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.InfoCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.InsertAfterCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.InsertBeforeCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.ItemCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.LinkWithNpcCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.ListCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.MoveDownCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.MoveHereCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.MoveToCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.NearbyCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.RemoveCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.RemoveLineCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.RotateCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.RotatePitchCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.ScaleCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.SeeThroughCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.SetLineCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.ShadowRadiusCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.ShadowStrengthCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.TeleportCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.TextAlignmentCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.TextShadowCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.TranslateCommand;
import com.fancyinnovations.fancyholograms.commands.hologram.UnlinkWithNpcCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.UpdateTextIntervalCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.VisibilityCMD;
import com.fancyinnovations.fancyholograms.commands.hologram.VisibilityDistanceCMD;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.fancyinnovations.fancyholograms.util.PluginUtils;
import com.fancyinnovations.fancynpcs.api.FancyNpcsPlugin;
import com.google.common.primitives.Ints;
import de.oliver.fancylib.MessageHelper;
import de.oliver.fancylib.colors.GlowingColor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.NotNull;

public final class HologramCMD
extends Command {
    private static final String HELP_TEXT = "<%primary_color%><b>FancyHolograms commands help:<reset>\n<%primary_color%>- /hologram help <dark_gray>- <white>Shows all (sub)commands\n<%primary_color%>- /hologram list <dark_gray>- <white>Shows you a overview of all holograms\n<%primary_color%>- /hologram nearby <range> <dark_gray>- <white>Shows all holograms nearby you in a range\n<%primary_color%>- /hologram teleport <name> <dark_gray>- <white>Teleports you to a hologram\n<%primary_color%>- /hologram create <name> <dark_gray>- <white>Creates a new hologram\n<%primary_color%>- /hologram remove <name> <dark_gray>- <white>Removes a hologram\n<%primary_color%>- /hologram copy <hologram> <new name> <dark_gray>- <white>Copies a hologram\n<%primary_color%>- /hologram edit <hologram> addLine <text ...> <dark_gray>- <white>Adds a line at the bottom\n<%primary_color%>- /hologram edit <hologram> removeLine <dark_gray>- <white>Removes a line at the bottom\n<%primary_color%>- /hologram edit <hologram> insertBefore <line number> <text ...> <dark_gray>- <white>Inserts a line before another\n<%primary_color%>- /hologram edit <hologram> insertAfter <line number> <text ...> <dark_gray>- <white>Inserts a line after another\n<%primary_color%>- /hologram edit <hologram> setLine <line number> <text ...> <dark_gray>- <white>Edits the line\n<%primary_color%>- /hologram edit <hologram> swapLines <first> <second> <dark_gray>- <white>Swaps two lines\n<%primary_color%>- /hologram edit <hologram> moveLineUp <line> <dark_gray>- <white>Moves a line up one position\n<%primary_color%>- /hologram edit <hologram> moveLineDown <line> <dark_gray>- <white>Moves a line down one position\n<%primary_color%>- /hologram edit <hologram> position <dark_gray>- <white>Teleports the hologram to you\n<%primary_color%>- /hologram edit <hologram> moveTo <x> <y> <z> [yaw] [pitch] <dark_gray>- <white>Teleports the hologram to the coordinates\n<%primary_color%>- /hologram edit <hologram> rotate <degrees> <dark_gray>- <white>Rotates the hologram\n<%primary_color%>- /hologram edit <hologram> scale <factor> <dark_gray>- <white>Changes the scale of the hologram\n<%primary_color%>- /hologram edit <hologram> billboard <center|fixed|horizontal|vertical> <factor> <dark_gray>- <white>Changes the billboard of the hologram\n<%primary_color%>- /hologram edit <hologram> background <color> <dark_gray>- <white>Changes the background of the hologram\n<%primary_color%>- /hologram edit <hologram> textShadow <true|false> <dark_gray>- <white>Enables/disables the text shadow\n<%primary_color%>- /hologram edit <hologram> textAlignment <alignment> <dark_gray>- <white>Sets the text alignment\n<%primary_color%>- /hologram edit <hologram> seeThrough <true|false> <dark_gray>- <white>Enables/disables whether the text can be seen through blocks\n<%primary_color%>- /hologram edit <hologram> shadowRadius <value> <dark_gray>- <white>Changes the shadow radius of the hologram\n<%primary_color%>- /hologram edit <hologram> shadowStrength <value> <dark_gray>- <white>Changes the shadow strength of the hologram\n<%primary_color%>- /hologram edit <hologram> brightness <block|sky> <0-15> <dark_gray>- <white>Changes the brightness of the hologram\n<%primary_color%>- /hologram edit <hologram> updateTextInterval <seconds> <dark_gray>- <white>Sets the interval for updating the text\n<%primary_color%>- /hologram edit <hologram> traits <add|remove> <trait name> <dark_gray>- <white>Adds or removes a trait to the hologram\n".replace("%primary_color%", MessageHelper.getPrimaryColor());
    private static final String HELP_TEXT_NPCS = "<%primary_color%>- /hologram edit <hologram> linkWithNpc <npc name> <dark_gray>- <white>Links the hologram with an NPC\n<%primary_color%>- /hologram edit <hologram> unlinkWithNpc <dark_gray>- <white>Unlinks the hologram with an NPC\n".replace("%primary_color%", MessageHelper.getPrimaryColor());
    @NotNull
    private final FancyHologramsPlugin plugin;

    public HologramCMD(@NotNull FancyHologramsPlugin plugin) {
        super("hologram", "Main command for the FancyHolograms plugin", "/hologram help", List.of("holograms", "holo", "fholo"));
        this.setPermission("fancyholograms.admin");
        this.plugin = plugin;
    }

    public static boolean callModificationEvent(@NotNull Hologram hologram, @NotNull CommandSender player, @NotNull HologramData updatedData, @NotNull HologramUpdateEvent.HologramModification modification) {
        boolean result = new HologramUpdateEvent(hologram, player, updatedData, modification).callEvent();
        if (!result) {
            MessageHelper.error(player, "Cancelled hologram modification");
        }
        return result;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            MessageHelper.info(sender, HELP_TEXT + (String)(!PluginUtils.isFancyNpcsEnabled() ? "" : "\n" + HELP_TEXT_NPCS));
            return false;
        }
        if (args[0].equalsIgnoreCase("list")) {
            return new ListCMD().run(sender, null, args);
        }
        if (args.length < 2) {
            MessageHelper.error(sender, "Wrong usage: /hologram help");
            return false;
        }
        if (args[0].equalsIgnoreCase("create")) {
            return new CreateCMD().run(sender, null, args);
        }
        if (args[0].equalsIgnoreCase("nearby")) {
            return new NearbyCMD().run(sender, null, args);
        }
        Hologram hologram = this.plugin.getRegistry().get(args[1]).orElse(null);
        if (hologram == null) {
            MessageHelper.error(sender, "Could not find hologram: '" + args[1] + "'");
            return false;
        }
        return switch (args[0].toLowerCase(Locale.ROOT)) {
            case "info" -> new InfoCMD().run(sender, hologram, args);
            case "remove" -> new RemoveCMD().run(sender, hologram, args);
            case "teleport" -> new TeleportCMD().run(sender, hologram, args);
            case "copy" -> new CopyCMD().run(sender, hologram, args);
            case "edit" -> {
                if (args.length < 3) {
                    MessageHelper.error(sender, "Wrong usage: /hologram help");
                    yield false;
                }
                boolean updated = this.edit(sender, hologram, args);
                if (updated && sender instanceof Player) {
                    Player p = (Player)sender;
                    this.plugin.getController().updateHologramData(hologram, p);
                }
                yield updated;
            }
            default -> false;
        };
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) throws IllegalArgumentException {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return Stream.of("help", "list", "teleport", "create", "remove", "edit", "copy", "info", "nearby").filter(input -> input.startsWith(args[0].toLowerCase(Locale.ROOT))).toList();
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("create")) {
            return Arrays.asList("text", "item", "block");
        }
        if (args.length == 2) {
            String action = args[0].toLowerCase(Locale.ROOT);
            if (!Set.of("teleport", "remove", "edit", "copy", "info").contains(action)) {
                return Collections.emptyList();
            }
            return this.plugin.getRegistry().getAllPersistent().stream().map(hologram -> hologram.getData().getName()).filter(input -> input.toLowerCase().startsWith(args[1].toLowerCase(Locale.ROOT))).toList();
        }
        Hologram hologram2 = this.plugin.getRegistry().get(args[1]).orElse(null);
        if (hologram2 == null) {
            return Collections.emptyList();
        }
        HologramType type = hologram2.getData().getType();
        if (args.length == 3) {
            if (!args[0].equalsIgnoreCase("edit")) {
                return Collections.emptyList();
            }
            boolean usingNpcs = PluginUtils.isFancyNpcsEnabled();
            ArrayList<String> suggestions = new ArrayList<String>(Arrays.asList("moveDown", "moveUp", "glowing", "traits", "position", "moveHere", "center", "moveTo", "rotate", "rotatepitch", "billboard", "scale", "translate", "visibilityDistance", "visibility", "shadowRadius", "shadowStrength", "brightness", usingNpcs ? "linkWithNpc" : "", usingNpcs ? "unlinkWithNpc" : ""));
            suggestions.addAll(type.getCommands());
            return suggestions.stream().filter(input -> input.toLowerCase().startsWith(args[2].toLowerCase(Locale.ROOT))).toList();
        }
        if (!args[0].equalsIgnoreCase("edit")) {
            return Collections.emptyList();
        }
        if (args.length == 4) {
            Stream<String> suggestions;
            switch (args[2].toLowerCase(Locale.ROOT)) {
                case "glowing": {
                    DisplayHologramData displayData;
                    ArrayList<GlowingColor> values = new ArrayList<GlowingColor>(List.of(GlowingColor.values()));
                    HologramData hologramData = hologram2.getData();
                    if (hologramData instanceof DisplayHologramData) {
                        displayData = (DisplayHologramData)hologramData;
                        values.remove((Object)displayData.getGlowingColor());
                    }
                    Stream<String> stream = values.stream().map(Enum::name);
                    break;
                }
                case "billboard": {
                    DisplayHologramData displayData;
                    ArrayList<GlowingColor> values = new ArrayList<Display.Billboard>(List.of(Display.Billboard.values()));
                    HologramData hologramData = hologram2.getData();
                    if (hologramData instanceof DisplayHologramData) {
                        displayData = (DisplayHologramData)hologramData;
                        values.remove(displayData.getBillboard());
                    }
                    Stream<String> stream = values.stream().map(Enum::name);
                    break;
                }
                case "background": {
                    TextHologramData textData = (TextHologramData)hologram2.getData();
                    ArrayList<Object> colors = new ArrayList<Object>(NamedTextColor.NAMES.keys());
                    colors.add("reset");
                    colors.add("default");
                    colors.add("transparent");
                    Color current = textData.getBackground();
                    if (current == null) {
                        colors.remove("reset");
                        colors.remove("default");
                    } else if (current == Hologram.TRANSPARENT) {
                        colors.remove("transparent");
                    } else {
                        NamedTextColor named = current.getAlpha() == 255 ? NamedTextColor.namedColor((int)current.asRGB()) : null;
                        colors.add(named != null ? named.toString() : "#" + Integer.toHexString(current.asARGB()));
                    }
                    Stream<String> stream = colors.stream();
                    break;
                }
                case "textshadow": {
                    TextHologramData textData = (TextHologramData)hologram2.getData();
                    Stream<String> stream = Stream.of(Boolean.valueOf(!textData.hasTextShadow())).map(Object::toString);
                    break;
                }
                case "brightness": {
                    Stream<String> stream = Stream.of("block", "sky");
                    break;
                }
                case "textalignment": {
                    Stream<String> stream = Arrays.stream(TextDisplay.TextAlignment.values()).map(Enum::name);
                    break;
                }
                case "setline": 
                case "removeline": 
                case "movedown": 
                case "moveup": {
                    TextHologramData textData = (TextHologramData)hologram2.getData();
                    Stream<String> stream = IntStream.range(1, textData.getText().size() + 1).mapToObj(Integer::toString);
                    break;
                }
                case "linkwithnpc": {
                    Stream<String> stream;
                    if (!PluginUtils.isFancyNpcsEnabled()) {
                        stream = Stream.empty();
                        break;
                    }
                    stream = FancyNpcsPlugin.get().getNpcManager().getAllNpcs().stream().map(npc -> npc.getData().getName());
                    break;
                }
                case "block": {
                    Stream<String> stream = Arrays.stream(Material.values()).filter(Material::isBlock).map(Enum::name);
                    break;
                }
                case "seethrough": {
                    Stream<String> stream = Stream.of("true", "false");
                    break;
                }
                case "visibility": {
                    Stream<String> stream = new VisibilityCMD().tabcompletion(sender, hologram2, args).stream();
                    break;
                }
                default: {
                    Stream<String> stream = suggestions = null;
                }
            }
            if (suggestions != null) {
                return suggestions.filter(input -> input.toLowerCase().startsWith(args[3].toLowerCase(Locale.ROOT))).toList();
            }
        }
        if (args[2].equalsIgnoreCase("setline")) {
            TextHologramData textData = (TextHologramData)hologram2.getData();
            Integer index = Ints.tryParse((String)args[3]);
            if (index == null || index < 1 || index > textData.getText().size()) {
                return Collections.emptyList();
            }
            return List.of(textData.getText().get(index - 1));
        }
        if (args[2].equalsIgnoreCase("moveto")) {
            Block target;
            if (!(sender instanceof Player)) {
                return Collections.emptyList();
            }
            Player player = (Player)sender;
            Object suggestions = new ArrayList();
            ((ArrayList)suggestions).add("~");
            ((ArrayList)suggestions).add("~~");
            if (args.length == 7) {
                ((ArrayList)suggestions).add(String.valueOf(player.getLocation().getYaw()));
            }
            if (args.length == 8) {
                ((ArrayList)suggestions).add(String.valueOf(player.getLocation().getPitch()));
            }
            if ((target = player.getTargetBlockExact(10)) != null) {
                Integer coordinate = switch (args.length) {
                    case 4 -> target.getX();
                    case 5 -> target.getY();
                    case 6 -> target.getZ();
                    default -> null;
                };
                ((ArrayList)suggestions).add(String.valueOf(coordinate));
            }
            return suggestions;
        }
        if (args[2].equalsIgnoreCase("brightness")) {
            if (args.length == 4) {
                return List.of("block", "sky");
            }
            if (args.length > 5) {
                return Collections.emptyList();
            }
            return List.of("0", "5", "10", "15");
        }
        return Collections.emptyList();
    }

    private boolean edit(@NotNull CommandSender player, @NotNull Hologram hologram, @NotNull String[] args) {
        String action = args[2].toLowerCase();
        try {
            switch (action) {
                case "position": 
                case "movehere": {
                    return new MoveHereCMD().run(player, hologram, args);
                }
                case "center": {
                    return new CenterCMD().run(player, hologram, args);
                }
                case "unlinkwithnpc": {
                    return new UnlinkWithNpcCMD().run(player, hologram, args);
                }
                case "item": {
                    return new ItemCMD().run(player, hologram, args);
                }
            }
            if (args.length == 3) {
                MessageHelper.error(player, "Wrong usage: /hologram help");
                return false;
            }
            return switch (action) {
                case "moveto" -> new MoveToCMD().run(player, hologram, args);
                case "rotate" -> new RotateCMD().run(player, hologram, args);
                case "rotatepitch" -> new RotatePitchCMD().run(player, hologram, args);
                case "billboard" -> new BillboardCMD().run(player, hologram, args);
                case "scale" -> new ScaleCMD().run(player, hologram, args);
                case "translate" -> new TranslateCommand().run(player, hologram, args);
                case "updatetextinterval" -> new UpdateTextIntervalCMD().run(player, hologram, args);
                case "visibilitydistance" -> new VisibilityDistanceCMD().run(player, hologram, args);
                case "visibility" -> new VisibilityCMD().run(player, hologram, args);
                case "linkwithnpc" -> new LinkWithNpcCMD().run(player, hologram, args);
                case "shadowradius" -> new ShadowRadiusCMD().run(player, hologram, args);
                case "shadowstrength" -> new ShadowStrengthCMD().run(player, hologram, args);
                case "brightness" -> new BrightnessCMD().run(player, hologram, args);
                case "background" -> new BackgroundCMD().run(player, hologram, args);
                case "addline" -> new AddLineCMD().run(player, hologram, args);
                case "setline" -> new SetLineCMD().run(player, hologram, args);
                case "removeline" -> new RemoveLineCMD().run(player, hologram, args);
                case "insertbefore" -> new InsertBeforeCMD().run(player, hologram, args);
                case "insertafter" -> new InsertAfterCMD().run(player, hologram, args);
                case "textshadow" -> new TextShadowCMD().run(player, hologram, args);
                case "textalignment" -> new TextAlignmentCMD().run(player, hologram, args);
                case "seethrough" -> new SeeThroughCMD().run(player, hologram, args);
                case "glowing" -> new GlowingCMD().run(player, hologram, args);
                case "movedown" -> new MoveDownCMD().run(player, hologram, args);
                case "block" -> new BlockCMD().run(player, hologram, args);
                default -> false;
            };
        }
        catch (ArrayIndexOutOfBoundsException | StringIndexOutOfBoundsException e) {
            MessageHelper.error(player, "Invalid command arguments. Use /hologram help for correct syntax");
            return false;
        }
        catch (NumberFormatException e) {
            MessageHelper.error(player, "Invalid number format in command arguments");
            return false;
        }
        catch (Exception e) {
            MessageHelper.error(player, "An error occurred while executing the command. Please check your syntax with /hologram help");
            this.plugin.getLogger().warning("Error executing hologram command: " + e.getMessage());
            return false;
        }
    }
}

