/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.api.data.builder;

import com.fancyinnovations.fancyholograms.api.FancyHolograms;
import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.data.property.Visibility;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.api.trait.HologramTrait;
import org.bukkit.entity.Display;
import org.joml.Vector3f;

public abstract class HologramBuilder {
    protected DisplayHologramData data;

    protected HologramBuilder() {
    }

    public Hologram build() {
        return FancyHolograms.get().getHologramFactory().apply(this.data);
    }

    public Hologram buildAndRegister() {
        Hologram hologram = this.build();
        FancyHolograms.get().getRegistry().register(hologram);
        return hologram;
    }

    public HologramBuilder visibilityDistance(int distance) {
        this.data.setVisibilityDistance(distance);
        return this;
    }

    public HologramBuilder visibility(Visibility visibility) {
        this.data.setVisibility(visibility);
        return this;
    }

    public HologramBuilder persistent(boolean persistent) {
        this.data.setPersistent(persistent);
        return this;
    }

    public HologramBuilder linkedNpcName(String linkedNpcName) {
        this.data.setLinkedNpcName(linkedNpcName);
        return this;
    }

    public final HologramBuilder trait(Class<? extends HologramTrait> trait) {
        this.data.addTrait(trait);
        return this;
    }

    public HologramBuilder billboard(Display.Billboard billboard) {
        this.data.setBillboard(billboard);
        return this;
    }

    public HologramBuilder scale(float x, float y, float z) {
        this.data.setScale(new Vector3f(x, y, z));
        return this;
    }

    public HologramBuilder translation(float x, float y, float z) {
        this.data.setTranslation(new Vector3f(x, y, z));
        return this;
    }

    public HologramBuilder brightness(int blockLight, int skyLight) {
        this.data.setBrightness(new Display.Brightness(blockLight, skyLight));
        return this;
    }

    public HologramBuilder shadowRadius(float shadowRadius) {
        this.data.setShadowRadius(shadowRadius);
        return this;
    }

    public HologramBuilder shadowStrength(float shadowStrength) {
        this.data.setShadowStrength(shadowStrength);
        return this;
    }

    public HologramBuilder interpolationDuration(int interpolationDuration) {
        this.data.setInterpolationDuration(interpolationDuration);
        return this;
    }
}

