/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.parameter.builtins;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.node.ExecutionContext;
import revxrsal.commands.parameter.ContextParameter;
import revxrsal.commands.process.SenderResolver;
import revxrsal.commands.util.Preconditions;

public final class SenderContextParameter<A extends CommandActor, T>
implements ContextParameter<A, T> {
    private final SenderResolver<A> resolver;

    public SenderContextParameter(SenderResolver<A> resolver) {
        this.resolver = resolver;
    }

    @Override
    public T resolve(@NotNull CommandParameter parameter, @NotNull ExecutionContext<A> context) {
        A actor = context.actor();
        Object sender = this.resolver.getSender(parameter.type(), actor, context.command());
        Preconditions.notNull(sender, "SenderResolver#getSender()");
        return (T)sender;
    }

    public SenderResolver<A> resolver() {
        return this.resolver;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SenderContextParameter that = (SenderContextParameter)obj;
        return Objects.equals(this.resolver, that.resolver);
    }

    public int hashCode() {
        return Objects.hash(this.resolver);
    }

    public String toString() {
        return "SenderContextParameter[resolver=" + this.resolver + ']';
    }
}

