/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.util;

import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.util.Preconditions;

public final class BukkitUtils {
    private static final boolean BRIGADIER = BukkitUtils.brigadierAvailable();

    private BukkitUtils() {
        Preconditions.cannotInstantiate(BukkitUtils.class);
    }

    private static boolean brigadierAvailable() {
        try {
            Class.forName("com.mojang.brigadier.arguments.StringArgumentType");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isBrigadierAvailable() {
        return BRIGADIER;
    }

    @NotNull
    public static String legacyColorize(@NotNull String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

