/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.metrics;

import com.fancyinnovations.fancyholograms.api.HologramRegistry;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import de.oliver.fancyanalytics.api.FancyAnalyticsAPI;
import de.oliver.fancyanalytics.api.metrics.MetricSupplier;
import de.oliver.fancyanalytics.logger.ExtendedFancyLogger;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.sdk.events.Event;
import de.oliver.fancylib.Metrics;
import de.oliver.fancylib.VersionConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class FHMetrics {
    private ExtendedFancyLogger logger = FancyHologramsPlugin.get().getFancyLogger();
    private FancyAnalyticsAPI fancyAnalytics;

    public void register() {
        this.fancyAnalytics = new FancyAnalyticsAPI("3b77bd59-2b01-46f2-b3aa-a9584401797f", "E2gW5zc2ZTk1OGFkNGY2ZDQ0ODlM6San");
        this.fancyAnalytics.getConfig().setDisableLogging(true);
        this.fancyAnalytics.registerMinecraftPluginMetrics((Plugin)FancyHologramsPlugin.get());
        this.fancyAnalytics.getExceptionHandler().registerLogger(FancyHologramsPlugin.get().getLogger());
        this.fancyAnalytics.getExceptionHandler().registerLogger(Bukkit.getLogger());
        this.fancyAnalytics.getExceptionHandler().registerLogger(this.logger);
        HologramRegistry registry = FancyHologramsPlugin.get().getRegistry();
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("commit_hash", () -> FancyHologramsPlugin.get().getVersionConfig().getCommitHash().substring(0, 7)));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("server_size", () -> {
            long onlinePlayers = Bukkit.getOnlinePlayers().size();
            if (onlinePlayers == 0L) {
                return "empty";
            }
            if (onlinePlayers <= 25L) {
                return "small";
            }
            if (onlinePlayers <= 100L) {
                return "medium";
            }
            if (onlinePlayers <= 500L) {
                return "large";
            }
            return "very_large";
        }));
        this.fancyAnalytics.registerNumberMetric(new MetricSupplier<Double>("amount_holograms", () -> registry.getAll().size()));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("enabled_update_notifications", () -> FancyHologramsPlugin.get().getFHConfiguration().areVersionNotificationsMuted() ? "false" : "true"));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("fflag_disable_holograms_for_bedrock_players", () -> FancyHologramsPlugin.get().getFHConfiguration().isHologramsForBedrockPlayersEnabled() ? "false" : "true"));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("using_development_build", () -> FancyHologramsPlugin.get().getVersionConfig().isDevelopmentBuild() ? "true" : "false"));
        this.fancyAnalytics.registerStringArrayMetric(new MetricSupplier<String[]>("hologram_type", () -> {
            if (registry == null) {
                return new String[0];
            }
            return (String[])registry.getAll().stream().map(h -> h.getData().getType().name()).toArray(String[]::new);
        }));
        this.fancyAnalytics.registerNumberMetric(new MetricSupplier<Double>("total_amount_attached_traits", () -> {
            double total = 0.0;
            for (Hologram hologram : registry.getAll()) {
                total += (double)hologram.getData().getTraitTrait().getTraits().size();
            }
            return total;
        }));
        this.fancyAnalytics.initialize();
    }

    public void registerLegacy() {
        Metrics metrics = new Metrics(FancyHologramsPlugin.get(), 17990);
        metrics.addCustomChart(new Metrics.SingleLineChart("total_holograms", () -> FancyHologramsPlugin.get().getRegistry().getAll().size()));
        metrics.addCustomChart(new Metrics.SimplePie("update_notifications", () -> FancyHologramsPlugin.get().getFHConfiguration().areVersionNotificationsMuted() ? "No" : "Yes"));
        metrics.addCustomChart(new Metrics.SimplePie("using_development_build", () -> FancyHologramsPlugin.get().getVersionConfig().isDevelopmentBuild() ? "Yes" : "No"));
    }

    public void checkIfPluginVersionUpdated() {
        VersionConfig versionConfig = FancyHologramsPlugin.get().getVersionConfig();
        String currentVersion = versionConfig.getVersion();
        String lastVersion = "N/A";
        File versionFile = new File(FancyHologramsPlugin.get().getDataFolder(), "version.yml");
        if (!versionFile.exists()) {
            try {
                Files.write(versionFile.toPath(), currentVersion.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                this.logger.warn("Could not write version file.", new Property[0]);
                return;
            }
        }
        try {
            lastVersion = new String(Files.readAllBytes(versionFile.toPath()));
        }
        catch (IOException e) {
            this.logger.warn("Could not read version file.", new Property[0]);
            return;
        }
        if (!lastVersion.equals(currentVersion)) {
            this.logger.info("Plugin has been updated from version " + lastVersion + " to " + currentVersion + ".", new Property[0]);
            this.fancyAnalytics.sendEvent(new Event("PluginVersionUpdated", new HashMap<String, String>()).withProperty("from", lastVersion).withProperty("to", currentVersion).withProperty("commit_hash", versionConfig.getCommitHash()).withProperty("channel", versionConfig.getChannel()).withProperty("platform", versionConfig.getPlatform()));
            try {
                Files.write(versionFile.toPath(), currentVersion.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                this.logger.warn("Could not write version file.", new Property[0]);
            }
        }
    }

    public FancyAnalyticsAPI getFancyAnalytics() {
        return this.fancyAnalytics;
    }
}

