/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.converter;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.converter.HologramConversionSession;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import de.oliver.fancyanalytics.sdk.events.Event;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class HologramConverter {
    @NotNull
    public abstract String getId();

    public abstract boolean canRunConverter();

    @NotNull
    protected abstract List<HologramData> convertHolograms(@NotNull HologramConversionSession var1);

    @NotNull
    public final List<HologramData> convert(@NotNull HologramConversionSession spec) {
        List<HologramData> converted = this.convertHolograms(spec);
        Event event = new Event("HologramsConverted", new HashMap<String, String>()).withProperty("converter", this.getId()).withProperty("target", spec.getTarget().getRegex().pattern()).withProperty("amount", String.valueOf(converted.size()));
        FancyHologramsPlugin.get().getMetrics().getFancyAnalytics().sendEvent(event);
        return converted;
    }

    @NotNull
    public List<String> getConvertableHolograms() {
        return List.of();
    }
}

