/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.lampCommands.hologram;

import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.api.trait.HologramTrait;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitRegistry;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitTrait;
import com.fancyinnovations.fancyholograms.commands.lampCommands.suggestions.AttachedTraitsSuggestion;
import com.fancyinnovations.fancyholograms.commands.lampCommands.suggestions.DetachedTraitsSuggestion;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import de.oliver.fancylib.translations.Translator;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.Description;
import revxrsal.commands.annotation.SuggestWith;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.annotation.CommandPermission;

public final class TraitCMD {
    public static final TraitCMD INSTANCE = new TraitCMD();
    private final FancyHologramsPlugin plugin = FancyHologramsPlugin.get();
    private final Translator translator = FancyHologramsPlugin.get().getTranslator();

    private TraitCMD() {
    }

    @Command(value={"hologram-new edit <hologram> trait attach <trait>"})
    @Description(value="Attaches a trait to a hologram")
    @CommandPermission(value="fancyholograms.commands.hologram.trait.attach")
    public void attach(@NotNull BukkitCommandActor actor, @NotNull Hologram hologram, @SuggestWith(value=AttachedTraitsSuggestion.class) @NotNull HologramTraitRegistry.TraitInfo trait) {
        if (hologram.getData().getTraitTrait().isTraitAttached(trait.clazz())) {
            this.translator.translate("commands.hologram.edit.trait.attach.already_attached").replace("hologram", hologram.getData().getName()).replace("name", trait.name()).send(actor.sender());
            return;
        }
        hologram.getData().addTrait(trait.clazz());
        this.translator.translate("commands.hologram.edit.trait.attach.success").replace("hologram", hologram.getData().getName()).replace("name", trait.name()).send(actor.sender());
    }

    @Command(value={"hologram-new edit <hologram> trait detach <trait>"})
    @Description(value="Detaches a trait to a hologram")
    @CommandPermission(value="fancyholograms.commands.hologram.trait.detach")
    public void detach(@NotNull BukkitCommandActor actor, @NotNull Hologram hologram, @SuggestWith(value=DetachedTraitsSuggestion.class) @NotNull HologramTraitRegistry.TraitInfo trait) {
        if (!hologram.getData().getTraitTrait().isTraitAttached(trait.clazz())) {
            this.translator.translate("commands.hologram.edit.trait.detach.not_attached").replace("hologram", hologram.getData().getName()).replace("name", trait.name()).send(actor.sender());
            return;
        }
        hologram.getData().getTraitTrait().removeTrait(trait.clazz());
        this.translator.translate("commands.hologram.edit.trait.detach.success").replace("hologram", hologram.getData().getName()).replace("name", trait.name()).send(actor.sender());
    }

    @Command(value={"hologram-new edit <hologram> trait list"})
    @Description(value="Lists all attached traits of a hologram")
    @CommandPermission(value="fancyholograms.commands.hologram.trait.list")
    public void list(@NotNull BukkitCommandActor actor, @NotNull Hologram hologram) {
        HologramTraitTrait traitTrait = hologram.getData().getTraitTrait();
        if (traitTrait.getTraits().isEmpty()) {
            this.translator.translate("commands.hologram.edit.trait.list.no_traits").replace("hologram", hologram.getData().getName()).send(actor.sender());
            return;
        }
        this.translator.translate("commands.hologram.edit.trait.list.header").replace("hologram", hologram.getData().getName()).send(actor.sender());
        for (HologramTrait trait : traitTrait.getTraits()) {
            this.translator.translate("commands.hologram.edit.trait.list.entry").replace("name", trait.getName()).send(actor.sender());
        }
    }
}

