/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.hologram;

import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.commands.Subcommand;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.google.common.primitives.Floats;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShadowRadiusCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        if (!player.hasPermission("fancyholograms.hologram.edit.shadow_radius")) {
            MessageHelper.error(player, "You don't have the required permission to edit a hologram");
            return false;
        }
        Float radius = Floats.tryParse((String)args[3]);
        if (radius == null) {
            MessageHelper.error(player, "Could not parse shadow radius");
            return false;
        }
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof DisplayHologramData)) {
            MessageHelper.error(player, "This command can only be used on display holograms");
            return false;
        }
        DisplayHologramData displayData = (DisplayHologramData)hologramData;
        if (Float.compare(radius.floatValue(), displayData.getShadowRadius()) == 0) {
            MessageHelper.warning(player, "This hologram already has this shadow radius");
            return false;
        }
        DisplayHologramData copied = displayData.copy(displayData.getName());
        copied.setShadowRadius(radius.floatValue());
        if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.SHADOW_RADIUS)) {
            return false;
        }
        if (Float.compare(copied.getShadowRadius(), displayData.getShadowRadius()) == 0) {
            MessageHelper.warning(player, "This hologram already has this shadow radius");
            return false;
        }
        displayData.setShadowRadius(copied.getShadowRadius());
        if (FancyHologramsPlugin.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHologramsPlugin.get().getStorage().save(hologram.getData());
        }
        MessageHelper.success(player, "Changed shadow radius");
        return true;
    }
}

