/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.hologram;

import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.Subcommand;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.fancyinnovations.fancyholograms.util.PluginUtils;
import com.fancyinnovations.fancynpcs.api.FancyNpcsPlugin;
import com.fancyinnovations.fancynpcs.api.Npc;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkWithNpcCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        if (!player.hasPermission("fancyholograms.hologram.link")) {
            MessageHelper.error(player, "You don't have the required permission to link a hologram");
            return false;
        }
        if (!PluginUtils.isFancyNpcsEnabled()) {
            MessageHelper.warning(player, "You need to install the FancyNpcs plugin for this functionality to work");
            MessageHelper.warning(player, "Download link: <click:open_url:'https://modrinth.com/plugin/fancynpcs/versions'><u>click here</u></click>.");
            return false;
        }
        String name = args[3];
        if (hologram.getData().getLinkedNpcName() != null) {
            MessageHelper.error(player, "This hologram is already linked with an NPC");
            return false;
        }
        Npc npc = FancyNpcsPlugin.get().getNpcManager().getNpc(name);
        if (npc == null) {
            MessageHelper.error(player, "Could not find NPC with that name");
            return false;
        }
        hologram.getData().setLinkedNpcName(npc.getData().getName());
        FancyHologramsPlugin.get().getControllerImpl().syncHologramWithNpc(hologram);
        if (FancyHologramsPlugin.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHologramsPlugin.get().getStorage().save(hologram.getData());
        }
        MessageHelper.success(player, "Linked hologram with NPC");
        return true;
    }
}

