/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.hologram;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.ItemHologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.commands.Subcommand;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender sender, @Nullable Hologram hologram, @NotNull String[] args) {
        if (!sender.hasPermission("fancyholograms.hologram.edit.item")) {
            MessageHelper.error(sender, "You don't have the required permission to edit a hologram");
            return false;
        }
        if (!(sender instanceof Player)) {
            MessageHelper.error(sender, "You must be a sender to use this command");
            return false;
        }
        Player player = (Player)sender;
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof ItemHologramData)) {
            MessageHelper.error((CommandSender)player, "This command can only be used on item holograms");
            return false;
        }
        ItemHologramData itemData = (ItemHologramData)hologramData;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR || item.getAmount() < 1) {
            MessageHelper.error((CommandSender)player, "You need to hold an item in your hand");
            return false;
        }
        if (item == itemData.getItemStack()) {
            MessageHelper.warning((CommandSender)player, "This item is already set");
            return false;
        }
        ItemHologramData copied = itemData.copy(itemData.getName());
        copied.setItemStack(item);
        if (!HologramCMD.callModificationEvent(hologram, (CommandSender)player, copied, HologramUpdateEvent.HologramModification.BILLBOARD)) {
            return false;
        }
        if (copied.getItemStack() == itemData.getItemStack()) {
            MessageHelper.warning((CommandSender)player, "This item is already set");
            return false;
        }
        itemData.setItemStack(item);
        if (FancyHologramsPlugin.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHologramsPlugin.get().getStorage().save(hologram.getData());
        }
        MessageHelper.success((CommandSender)player, "Set the item to '" + item.getType().name() + "'");
        return true;
    }
}

