/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.hologram;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.commands.Subcommand;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.google.common.primitives.Ints;
import de.oliver.fancylib.MessageHelper;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertBeforeCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        if (!player.hasPermission("fancyholograms.hologram.edit.insert_before")) {
            MessageHelper.error(player, "You don't have the required permission to edit a hologram");
            return false;
        }
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            MessageHelper.error(player, "This command can only be used on text holograms");
            return false;
        }
        TextHologramData textData = (TextHologramData)hologramData;
        Integer index = Ints.tryParse((String)args[3]);
        if (index == null) {
            MessageHelper.error(player, "Could not parse line number");
            return false;
        }
        Integer n = index;
        index = index - 1;
        if (index < 0) {
            MessageHelper.error(player, "Invalid line index");
            return false;
        }
        Object text = "";
        for (int i = 4; i < args.length; ++i) {
            text = (String)text + args[i] + " ";
        }
        if (((String)text).isEmpty()) {
            MessageHelper.error(player, "You need to provide a text to insert");
            return true;
        }
        text = ((String)text).substring(0, ((String)text).length() - 1);
        ArrayList<String> lines = new ArrayList<String>(textData.getText());
        lines.add(Math.min(index, lines.size()), (String)text);
        TextHologramData copied = textData.copy(textData.getName());
        copied.setText(lines);
        if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.TEXT)) {
            return false;
        }
        textData.setText(copied.getText());
        if (FancyHologramsPlugin.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHologramsPlugin.get().getStorage().save(hologram.getData());
        }
        MessageHelper.success(player, "Inserted line");
        return true;
    }
}

