/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.api.data.property;

import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.google.common.collect.HashMultimap;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Player;

public enum Visibility {
    ALL((player, hologram) -> true),
    PERMISSION_REQUIRED((player, hologram) -> player.hasPermission("fancyholograms.viewhologram." + hologram.getData().getName())),
    MANUAL(ManualVisibility::canSee);

    private final VisibilityPredicate predicate;

    private Visibility(VisibilityPredicate predicate) {
        this.predicate = predicate;
    }

    public static Optional<Visibility> byString(String value) {
        return Arrays.stream(Visibility.values()).filter(visibility -> visibility.toString().equalsIgnoreCase(value)).findFirst();
    }

    public boolean canSee(Player player, Hologram hologram) {
        return this.predicate.canSee(player, hologram);
    }

    @FunctionalInterface
    public static interface VisibilityPredicate {
        public boolean canSee(Player var1, Hologram var2);
    }

    public static class ManualVisibility {
        private static final HashMultimap<String, UUID> distantViewers = HashMultimap.create();

        public static boolean canSee(Player player, Hologram hologram) {
            return hologram.isViewer(player) || distantViewers.containsEntry((Object)hologram.getData().getName(), (Object)player.getUniqueId());
        }

        public static void addDistantViewer(Hologram hologram, UUID uuid) {
            ManualVisibility.addDistantViewer(hologram.getData().getName(), uuid);
        }

        public static void addDistantViewer(String hologramName, UUID uuid) {
            distantViewers.put((Object)hologramName, (Object)uuid);
        }

        public static void removeDistantViewer(Hologram hologram, UUID uuid) {
            ManualVisibility.removeDistantViewer(hologram.getData().getName(), uuid);
        }

        public static void removeDistantViewer(String hologramName, UUID uuid) {
            distantViewers.remove((Object)hologramName, (Object)uuid);
        }

        public static void remove(Hologram hologram) {
            ManualVisibility.remove(hologram.getData().getName());
        }

        public static void remove(String hologramName) {
            distantViewers.removeAll((Object)hologramName);
        }

        public static void clear() {
            distantViewers.clear();
        }
    }
}

