/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.api.data;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.hologram.HologramType;
import de.oliver.fancylib.colors.GlowingColor;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Display;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DisplayHologramData
extends HologramData {
    public static final Display.Billboard DEFAULT_BILLBOARD = Display.Billboard.CENTER;
    public static final Vector3f DEFAULT_SCALE = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Vector3f DEFAULT_TRANSLATION = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final float DEFAULT_SHADOW_RADIUS = 0.0f;
    public static final float DEFAULT_SHADOW_STRENGTH = 1.0f;
    public static final int DEFAULT_INTERPOLATION_DURATION = 0;
    public static final GlowingColor DEFAULT_GLOWING_COLOR = GlowingColor.DISABLED;
    private Display.Billboard billboard = DEFAULT_BILLBOARD;
    private Vector3f scale = new Vector3f((Vector3fc)DEFAULT_SCALE);
    private Vector3f translation = new Vector3f((Vector3fc)DEFAULT_TRANSLATION);
    private Display.Brightness brightness;
    private float shadowRadius = 0.0f;
    private float shadowStrength = 1.0f;
    private int interpolationDuration = 0;
    private GlowingColor glowingColor = DEFAULT_GLOWING_COLOR;

    public DisplayHologramData(String name, HologramType type, Location location) {
        super(name, type, location);
    }

    public Display.Billboard getBillboard() {
        return this.billboard;
    }

    public DisplayHologramData setBillboard(Display.Billboard billboard) {
        if (!Objects.equals(this.billboard, billboard)) {
            this.billboard = billboard;
            this.setHasChanges(true);
        }
        return this;
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public DisplayHologramData setScale(Vector3f scale) {
        if (!Objects.equals(this.scale, scale)) {
            this.scale = scale;
            this.setHasChanges(true);
        }
        return this;
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public DisplayHologramData setTranslation(Vector3f translation) {
        if (!Objects.equals(this.translation, translation)) {
            this.translation = translation;
            this.setHasChanges(true);
        }
        return this;
    }

    public Display.Brightness getBrightness() {
        return this.brightness;
    }

    public DisplayHologramData setBrightness(Display.Brightness brightness) {
        if (!Objects.equals(this.brightness, brightness)) {
            this.brightness = brightness;
            this.setHasChanges(true);
        }
        return this;
    }

    public float getShadowRadius() {
        return this.shadowRadius;
    }

    public DisplayHologramData setShadowRadius(float shadowRadius) {
        if (this.shadowRadius != shadowRadius) {
            this.shadowRadius = shadowRadius;
            this.setHasChanges(true);
        }
        return this;
    }

    public float getShadowStrength() {
        return this.shadowStrength;
    }

    public DisplayHologramData setShadowStrength(float shadowStrength) {
        if (this.shadowStrength != shadowStrength) {
            this.shadowStrength = shadowStrength;
            this.setHasChanges(true);
        }
        return this;
    }

    @ApiStatus.Experimental
    public int getInterpolationDuration() {
        return this.interpolationDuration;
    }

    @ApiStatus.Experimental
    public DisplayHologramData setInterpolationDuration(int interpolationDuration) {
        if (this.interpolationDuration != interpolationDuration) {
            this.interpolationDuration = interpolationDuration;
            this.setHasChanges(true);
        }
        return this;
    }

    public GlowingColor getGlowingColor() {
        return this.glowingColor;
    }

    public DisplayHologramData setGlowingColor(GlowingColor glowingColor) {
        if (!Objects.equals((Object)this.glowingColor, (Object)glowingColor)) {
            this.glowingColor = glowingColor;
            this.setHasChanges(true);
        }
        return this;
    }

    @Override
    @ApiStatus.Internal
    public boolean read(ConfigurationSection section, String name) {
        super.read(section, name);
        this.scale = new Vector3f((float)section.getDouble("scale_x", (double)DisplayHologramData.DEFAULT_SCALE.x), (float)section.getDouble("scale_y", (double)DisplayHologramData.DEFAULT_SCALE.y), (float)section.getDouble("scale_z", (double)DisplayHologramData.DEFAULT_SCALE.z));
        this.translation = new Vector3f((float)section.getDouble("translation_x", (double)DisplayHologramData.DEFAULT_TRANSLATION.x), (float)section.getDouble("translation_y", (double)DisplayHologramData.DEFAULT_TRANSLATION.y), (float)section.getDouble("translation_z", (double)DisplayHologramData.DEFAULT_TRANSLATION.z));
        this.shadowRadius = (float)section.getDouble("shadow_radius", 0.0);
        this.shadowStrength = (float)section.getDouble("shadow_strength", 1.0);
        String billboardStr = section.getString("billboard", DEFAULT_BILLBOARD.name());
        this.billboard = switch (billboardStr.toLowerCase()) {
            case "fixed" -> Display.Billboard.FIXED;
            case "vertical" -> Display.Billboard.VERTICAL;
            case "horizontal" -> Display.Billboard.HORIZONTAL;
            default -> Display.Billboard.CENTER;
        };
        int blockBrightness = Math.min(15, section.getInt("block_brightness", -1));
        int skyBrightness = Math.min(15, section.getInt("sky_brightness", -1));
        if (blockBrightness > -1 || skyBrightness > -1) {
            this.brightness = new Display.Brightness(Math.max(0, blockBrightness), Math.max(0, skyBrightness));
        }
        String glowingColorStr = section.getString("glowing_color", DEFAULT_GLOWING_COLOR.name());
        try {
            this.glowingColor = GlowingColor.valueOf(glowingColorStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.glowingColor = DEFAULT_GLOWING_COLOR;
        }
        return true;
    }

    @Override
    @ApiStatus.Internal
    public boolean write(ConfigurationSection section, String name) {
        super.write(section, name);
        section.set("scale_x", (Object)Float.valueOf(this.scale.x));
        section.set("scale_y", (Object)Float.valueOf(this.scale.y));
        section.set("scale_z", (Object)Float.valueOf(this.scale.z));
        section.set("translation_x", (Object)Float.valueOf(this.translation.x));
        section.set("translation_y", (Object)Float.valueOf(this.translation.y));
        section.set("translation_z", (Object)Float.valueOf(this.translation.z));
        section.set("shadow_radius", (Object)Float.valueOf(this.shadowRadius));
        section.set("shadow_strength", (Object)Float.valueOf(this.shadowStrength));
        if (this.brightness != null) {
            section.set("block_brightness", (Object)this.brightness.getBlockLight());
            section.set("sky_brightness", (Object)this.brightness.getSkyLight());
        }
        section.set("billboard", this.billboard != Display.Billboard.CENTER ? this.billboard.name().toLowerCase(Locale.ROOT) : null);
        section.set("glowing_color", this.glowingColor != DEFAULT_GLOWING_COLOR ? this.glowingColor.name().toLowerCase(Locale.ROOT) : null);
        return true;
    }

    @Override
    public DisplayHologramData copy(String name) {
        DisplayHologramData displayHologramData = new DisplayHologramData(name, this.getType(), this.getLocation());
        displayHologramData.setScale(this.getScale()).setShadowRadius(this.getShadowRadius()).setShadowStrength(this.getShadowStrength()).setBillboard(this.getBillboard()).setTranslation(this.getTranslation()).setBrightness(this.getBrightness()).setGlowingColor(this.getGlowingColor()).setVisibilityDistance(this.getVisibilityDistance()).setVisibility(this.getVisibility()).setPersistent(this.isPersistent()).setLinkedNpcName(this.getLinkedNpcName());
        return displayHologramData;
    }
}

