/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.commands.hologram;

import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.data.BlockHologramData;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.events.HologramUpdateEvent;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.commands.HologramCMD;
import de.oliver.fancyholograms.commands.Subcommand;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        if (!player.hasPermission("fancyholograms.hologram.edit.block")) {
            MessageHelper.error(player, "You don't have the required permission to change the block of this hologram");
            return false;
        }
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof BlockHologramData)) {
            MessageHelper.error(player, "This command can only be used on item holograms");
            return false;
        }
        BlockHologramData blockData = (BlockHologramData)hologramData;
        Material block = Material.getMaterial((String)args[3]);
        if (block == null) {
            MessageHelper.error(player, "Could not find block type");
            return false;
        }
        if (block == blockData.getBlock()) {
            MessageHelper.warning(player, "This block is already set");
            return false;
        }
        BlockHologramData copied = blockData.copy(blockData.getName());
        copied.setBlock(block);
        if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.BILLBOARD)) {
            return false;
        }
        if (copied.getBlock() == blockData.getBlock()) {
            MessageHelper.warning(player, "This block is already set");
            return false;
        }
        blockData.setBlock(block);
        if (FancyHolograms.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHolograms.get().getHologramStorage().save(hologram);
        }
        MessageHelper.success(player, "Set block to '" + block.name() + "'");
        return true;
    }
}

