/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.HologramManager;
import de.oliver.fancyholograms.api.data.DisplayHologramData;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.events.HologramsLoadedEvent;
import de.oliver.fancyholograms.api.events.HologramsUnloadedEvent;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancylib.serverSoftware.ServerSoftware;
import de.oliver.fancynpcs.api.FancyNpcsPlugin;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import org.joml.Vector3f;

public final class HologramManagerImpl
implements HologramManager {
    @NotNull
    private final FancyHolograms plugin;
    @NotNull
    private final Function<HologramData, Hologram> adapter;
    private final Map<String, Hologram> holograms = new ConcurrentHashMap<String, Hologram>();
    private final boolean hologramLoadLogging;
    private boolean isLoaded = false;

    HologramManagerImpl(@NotNull FancyHolograms plugin, @NotNull Function<HologramData, Hologram> adapter) {
        this.plugin = plugin;
        this.adapter = adapter;
        this.hologramLoadLogging = plugin.getHologramConfiguration().isHologramLoadLogging();
    }

    @Override
    @NotNull
    public @UnmodifiableView Collection<Hologram> getHolograms() {
        return Collections.unmodifiableCollection(this.holograms.values());
    }

    @Override
    @NotNull
    public @UnmodifiableView Collection<Hologram> getPersistentHolograms() {
        return this.holograms.values().stream().filter(hologram -> hologram.getData().isPersistent()).toList();
    }

    @Override
    @NotNull
    public Optional<Hologram> getHologram(@NotNull String name) {
        return Optional.ofNullable(this.holograms.get(name.toLowerCase(Locale.ROOT)));
    }

    @Override
    public void addHologram(@NotNull Hologram hologram) {
        this.holograms.put(hologram.getData().getName().toLowerCase(Locale.ROOT), hologram);
    }

    @Override
    public void removeHologram(@NotNull Hologram hologram) {
        this.removeHologram(hologram.getData().getName());
    }

    @NotNull
    public Optional<Hologram> removeHologram(@NotNull String name) {
        Optional<Hologram> optionalHologram = Optional.ofNullable(this.holograms.remove(name.toLowerCase(Locale.ROOT)));
        optionalHologram.ifPresent(hologram -> {
            for (UUID viewer : hologram.getViewers()) {
                Player player = Bukkit.getPlayer((UUID)viewer);
                if (player == null) continue;
                FancyHolograms.get().getHologramThread().submit(() -> hologram.forceHideHologram(player));
            }
            FancyHolograms.get().getHologramThread().submit(() -> this.plugin.getHologramStorage().delete((Hologram)hologram));
        });
        return optionalHologram;
    }

    @Override
    @NotNull
    public Hologram create(@NotNull HologramData data) {
        Hologram hologram = this.adapter.apply(data);
        hologram.createHologram();
        return hologram;
    }

    @Override
    public void saveHolograms() {
        if (!this.isLoaded) {
            return;
        }
        this.plugin.getHologramStorage().saveBatch(this.getPersistentHolograms(), false);
    }

    @Override
    public void loadHolograms() {
        ArrayList<Hologram> allLoaded = new ArrayList<Hologram>();
        for (World world : Bukkit.getWorlds()) {
            Collection<Hologram> loaded = this.plugin.getHologramStorage().loadAll(world.getName());
            loaded.forEach(this::addHologram);
            allLoaded.addAll(loaded);
        }
        this.isLoaded = true;
        FancyHolograms.get().getHologramThread().submit(() -> {
            Bukkit.getPluginManager().callEvent((Event)new HologramsLoadedEvent((ImmutableList<Hologram>)ImmutableList.copyOf((Collection)allLoaded)));
            for (Hologram hologram : allLoaded) {
                if (hologram.getData().getLinkedNpcName() == null) continue;
                this.syncHologramWithNpc(hologram);
            }
        });
        if (this.hologramLoadLogging) {
            FancyHolograms.get().getFancyLogger().info(String.format("Loaded %d holograms for all loaded worlds", allLoaded.size()), new Property[0]);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void loadHolograms(String world) {
        ImmutableList loaded = ImmutableList.copyOf(this.plugin.getHologramStorage().loadAll(world));
        loaded.forEach(this::addHologram);
        this.isLoaded = true;
        FancyHolograms.get().getHologramThread().submit(() -> {
            Bukkit.getPluginManager().callEvent((Event)new HologramsLoadedEvent((ImmutableList<Hologram>)ImmutableList.copyOf((Collection)loaded)));
            for (Hologram hologram : loaded) {
                if (hologram.getData().getLinkedNpcName() == null) continue;
                this.syncHologramWithNpc(hologram);
            }
        });
        if (this.hologramLoadLogging) {
            FancyHolograms.get().getFancyLogger().info(String.format("Loaded %d holograms for world %s", loaded.size(), world), new Property[0]);
        }
    }

    void initializeTasks() {
        ScheduledExecutorService hologramThread = this.plugin.getHologramThread();
        hologramThread.submit(() -> {
            this.loadHolograms();
            hologramThread.scheduleAtFixedRate(() -> {
                for (Hologram hologram : this.plugin.getHologramsManager().getHolograms()) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (ServerSoftware.isFolia()) {
                            player.getScheduler().run((Plugin)FancyHolograms.get().getPlugin(), t -> hologram.forceUpdateShownStateFor(player), null);
                            continue;
                        }
                        hologram.forceUpdateShownStateFor(player);
                    }
                }
            }, 0L, (long)this.plugin.getHologramConfiguration().getUpdateVisibilityInterval() * 50L, TimeUnit.MILLISECONDS);
        });
        Cache updateTimes = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).build();
        hologramThread.scheduleAtFixedRate(() -> {
            long time = System.currentTimeMillis();
            for (Hologram hologram : this.getHolograms()) {
                HologramData data = hologram.getData();
                if (!data.hasChanges()) continue;
                hologram.forceUpdate();
                hologram.refreshForViewersInWorld();
                data.setHasChanges(false);
                if (!(data instanceof TextHologramData)) continue;
                updateTimes.put((Object)hologram.getData().getName(), (Object)time);
            }
        }, 50L, 1000L, TimeUnit.MILLISECONDS);
        hologramThread.scheduleWithFixedDelay(() -> {
            long time = System.currentTimeMillis();
            for (Hologram hologram : this.getHolograms()) {
                Long lastUpdate;
                TextHologramData textData;
                int interval;
                HologramData patt0$temp = hologram.getData();
                if (!(patt0$temp instanceof TextHologramData) || (interval = (textData = (TextHologramData)patt0$temp).getTextUpdateInterval()) < 1 || (lastUpdate = (Long)updateTimes.asMap().get(textData.getName())) != null && time < lastUpdate + (long)interval || lastUpdate != null && time <= lastUpdate + (long)interval) continue;
                hologram.refreshForViewersInWorld();
                updateTimes.put((Object)textData.getName(), (Object)time);
            }
        }, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void reloadHolograms() {
        this.unloadHolograms();
        this.loadHolograms();
    }

    public void unloadHolograms() {
        FancyHolograms.get().getHologramThread().submit(() -> {
            ArrayList<Hologram> unloaded = new ArrayList<Hologram>();
            for (Hologram hologram : this.getPersistentHolograms()) {
                this.holograms.remove(hologram.getName());
                unloaded.add(hologram);
                for (UUID viewer : hologram.getViewers()) {
                    Player player = Bukkit.getPlayer((UUID)viewer);
                    if (player == null) continue;
                    hologram.forceHideHologram(player);
                }
            }
            Bukkit.getPluginManager().callEvent((Event)new HologramsUnloadedEvent((ImmutableList<Hologram>)ImmutableList.copyOf(unloaded)));
        });
    }

    public void unloadHolograms(String world) {
        List online = List.copyOf(Bukkit.getOnlinePlayers());
        FancyHolograms.get().getHologramThread().submit(() -> {
            List<Hologram> h = this.getPersistentHolograms().stream().filter(hologram -> hologram.getData().getLocation().getWorld().getName().equals(world)).toList();
            FancyHolograms.get().getHologramStorage().saveBatch(h, false);
            for (Hologram hologram2 : h) {
                this.holograms.remove(hologram2.getName());
                online.forEach(hologram2::forceHideHologram);
            }
            Bukkit.getPluginManager().callEvent((Event)new HologramsUnloadedEvent((ImmutableList<Hologram>)ImmutableList.copyOf(h)));
        });
    }

    public void syncHologramWithNpc(@NotNull Hologram hologram) {
        String pose;
        NpcAttribute poseAttr;
        String linkedNpcName = hologram.getData().getLinkedNpcName();
        if (linkedNpcName == null) {
            return;
        }
        Npc npc = FancyNpcsPlugin.get().getNpcManager().getNpc(linkedNpcName);
        if (npc == null) {
            return;
        }
        npc.getData().setDisplayName("<empty>");
        npc.getData().setShowInTab(false);
        npc.updateForAll();
        float npcScale = npc.getData().getScale();
        HologramData hologramData = hologram.getData();
        if (hologramData instanceof DisplayHologramData) {
            DisplayHologramData displayData = (DisplayHologramData)hologramData;
            displayData.setScale(new Vector3f(npcScale));
        }
        Location location = npc.getData().getLocation().clone().add(0.0, (double)(npc.getEyeHeight() * npcScale) + 0.5 * (double)npcScale, 0.0);
        if (npc.getData().getType() == EntityType.PLAYER && (poseAttr = FancyNpcsPlugin.get().getAttributeManager().getAttributeByName(npc.getData().getType(), "pose")) != null && (pose = (String)npc.getData().getAttributes().get(poseAttr)) != null) {
            switch (pose.toLowerCase()) {
                case "sitting": {
                    location.subtract(0.0, 0.7 * (double)npcScale, 0.0);
                    break;
                }
                case "sleeping": {
                    location.subtract(0.0, 0.4 * (double)npcScale, 0.0);
                    break;
                }
                case "crouching": {
                    location.subtract(0.0, 0.1 * (double)npcScale, 0.0);
                }
            }
        }
        hologram.getData().setLocation(location);
    }
}

