/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.storage;

import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.HologramStorage;
import de.oliver.fancyholograms.api.data.BlockHologramData;
import de.oliver.fancyholograms.api.data.DisplayHologramData;
import de.oliver.fancyholograms.api.data.ItemHologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.api.hologram.HologramType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlatFileHologramStorage
implements HologramStorage {
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final File HOLOGRAMS_CONFIG_FILE = new File("plugins/FancyHolograms/holograms.yml");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveBatch(Collection<Hologram> holograms, boolean override) {
        lock.readLock().lock();
        boolean success = false;
        YamlConfiguration config = null;
        try {
            config = YamlConfiguration.loadConfiguration((File)HOLOGRAMS_CONFIG_FILE);
            if (override) {
                config.set("holograms", null);
            }
            for (Hologram hologram : holograms) {
                this.writeHologram(config, hologram);
            }
            success = true;
        }
        finally {
            lock.readLock().unlock();
            if (success) {
                this.saveConfig(config);
            }
        }
        FancyHolograms.get().getFancyLogger().debug("Saved " + holograms.size() + " holograms to file (override=" + override + ")", new Property[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Hologram hologram) {
        lock.readLock().lock();
        boolean success = false;
        YamlConfiguration config = null;
        try {
            config = YamlConfiguration.loadConfiguration((File)HOLOGRAMS_CONFIG_FILE);
            this.writeHologram(config, hologram);
            success = true;
        }
        finally {
            lock.readLock().unlock();
            if (success) {
                this.saveConfig(config);
            }
        }
        FancyHolograms.get().getFancyLogger().debug("Saved hologram " + hologram.getData().getName() + " to file", new Property[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Hologram hologram) {
        lock.readLock().lock();
        boolean success = false;
        YamlConfiguration config = null;
        try {
            config = YamlConfiguration.loadConfiguration((File)HOLOGRAMS_CONFIG_FILE);
            config.set("holograms." + hologram.getData().getName(), null);
            success = true;
        }
        finally {
            lock.readLock().unlock();
            if (success) {
                this.saveConfig(config);
            }
        }
        FancyHolograms.get().getFancyLogger().debug("Deleted hologram " + hologram.getData().getName() + " from file", new Property[0]);
    }

    @Override
    public Collection<Hologram> loadAll() {
        List<Hologram> holograms = this.readHolograms(HOLOGRAMS_CONFIG_FILE, null);
        FancyHolograms.get().getFancyLogger().debug("Loaded " + holograms.size() + " holograms from file", new Property[0]);
        return holograms;
    }

    @Override
    public Collection<Hologram> loadAll(String world) {
        List<Hologram> holograms = this.readHolograms(HOLOGRAMS_CONFIG_FILE, world);
        FancyHolograms.get().getFancyLogger().debug("Loaded " + holograms.size() + " holograms from file (world=" + world + ")", new Property[0]);
        return holograms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Hologram> readHolograms(@NotNull File configFile, @Nullable String world) {
        lock.readLock().lock();
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            if (!config.isConfigurationSection("holograms")) {
                FancyHolograms.get().getFancyLogger().warn("No holograms section found in config", new Property[0]);
                ArrayList<Hologram> arrayList = new ArrayList<Hologram>(0);
                return arrayList;
            }
            int configVersion = config.getInt("version", 1);
            if (configVersion != 2) {
                FancyHolograms.get().getFancyLogger().warn("Config version is not 2, skipping loading holograms", new Property[0]);
                FancyHolograms.get().getFancyLogger().warn("Old config version detected, skipping loading holograms", new Property[0]);
                ArrayList<Hologram> arrayList = new ArrayList<Hologram>(0);
                return arrayList;
            }
            ArrayList<Hologram> holograms = new ArrayList<Hologram>();
            ConfigurationSection hologramsSection = config.getConfigurationSection("holograms");
            for (String name : hologramsSection.getKeys(false)) {
                ConfigurationSection holoSection = hologramsSection.getConfigurationSection(name);
                if (holoSection == null) {
                    FancyHolograms.get().getFancyLogger().warn("Could not load hologram section in config", new Property[0]);
                    continue;
                }
                if (world != null && !holoSection.getString("location.world").equals(world)) continue;
                String typeName = holoSection.getString("type");
                if (typeName == null) {
                    FancyHolograms.get().getFancyLogger().warn("HologramType was not saved", new Property[0]);
                    continue;
                }
                HologramType type = HologramType.getByName(typeName);
                if (type == null) {
                    FancyHolograms.get().getFancyLogger().warn("Could not parse HologramType", new Property[0]);
                    continue;
                }
                DisplayHologramData displayData = null;
                switch (type) {
                    case TEXT: {
                        displayData = new TextHologramData(name, new Location(null, 0.0, 0.0, 0.0));
                        break;
                    }
                    case ITEM: {
                        displayData = new ItemHologramData(name, new Location(null, 0.0, 0.0, 0.0));
                        break;
                    }
                    case BLOCK: {
                        displayData = new BlockHologramData(name, new Location(null, 0.0, 0.0, 0.0));
                    }
                }
                if (!displayData.read(holoSection, name)) {
                    FancyHolograms.get().getFancyLogger().warn("Could not read hologram data - skipping hologram", new Property[0]);
                    continue;
                }
                Hologram hologram = FancyHolograms.get().getHologramManager().create(displayData);
                holograms.add(hologram);
            }
            FancyHolograms.get().getFancyLogger().debug("Loaded " + holograms.size() + " holograms from file", new Property[0]);
            ArrayList<Hologram> arrayList = holograms;
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    private void writeHologram(YamlConfiguration config, Hologram hologram) {
        String holoName;
        @NotNull ConfigurationSection section = !config.isConfigurationSection("holograms") ? config.createSection("holograms") : Objects.requireNonNull(config.getConfigurationSection("holograms"));
        ConfigurationSection holoSection = section.getConfigurationSection(holoName = hologram.getData().getName());
        if (holoSection == null) {
            holoSection = section.createSection(holoName);
        }
        hologram.getData().write(holoSection, holoName);
        FancyHolograms.get().getFancyLogger().debug("Wrote hologram " + holoName + " to config", new Property[0]);
    }

    private void saveConfig(YamlConfiguration config) {
        config.set("version", (Object)2);
        config.setInlineComments("version", List.of("DO NOT CHANGE"));
        FancyHolograms.get().getFileStorageExecutor().execute(() -> {
            lock.writeLock().lock();
            try {
                config.save(HOLOGRAMS_CONFIG_FILE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                lock.writeLock().unlock();
            }
            if (!FancyHolograms.canGet()) {
                return;
            }
            FancyHolograms.get().getFancyLogger().debug("Saved config to file", new Property[0]);
        });
    }
}

