/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.commands.hologram;

import com.google.common.primitives.Ints;
import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.events.HologramUpdateEvent;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.commands.HologramCMD;
import de.oliver.fancyholograms.commands.Subcommand;
import de.oliver.fancylib.MessageHelper;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetLineCMD
implements Subcommand {
    public static boolean setLine(CommandSender player, Hologram hologram, int index, String text) {
        if (!player.hasPermission("fancyholograms.hologram.line.set")) {
            MessageHelper.error(player, "You don't have the required permission to set a line to this hologram");
            return false;
        }
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            MessageHelper.error(player, "This command can only be used on text holograms");
            return false;
        }
        TextHologramData textData = (TextHologramData)hologramData;
        ArrayList<String> lines = new ArrayList<String>(textData.getText());
        if (index >= lines.size()) {
            lines.add(text == null ? " " : text);
        } else if (text == null) {
            lines.remove(index);
        } else {
            lines.set(index, text);
        }
        TextHologramData copied = textData.copy(textData.getName());
        copied.setText(lines);
        if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.TEXT)) {
            return false;
        }
        textData.setText(copied.getText());
        if (FancyHolograms.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHolograms.get().getHologramStorage().save(hologram);
        }
        MessageHelper.success(player, "Changed text for line " + (Math.min(index, lines.size() - 1) + 1));
        return true;
    }

    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        Integer index = Ints.tryParse((String)args[3]);
        if (index == null) {
            MessageHelper.error(player, "Could not parse line number");
            return false;
        }
        if (index < 0) {
            MessageHelper.error(player, "Invalid line index");
            return false;
        }
        Integer n = index;
        index = index - 1;
        StringBuilder text = new StringBuilder();
        for (int i = 4; i < args.length; ++i) {
            text.append(args[i]).append(" ");
        }
        text = new StringBuilder(text.substring(0, text.length() - 1));
        return SetLineCMD.setLine(player, hologram, index, text.toString());
    }
}

