/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.listeners;

import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancylib.FancyLib;
import de.oliver.fancylib.MessageHelper;
import de.oliver.fancynpcs.api.events.NpcModifyEvent;
import de.oliver.fancynpcs.api.events.NpcRemoveEvent;
import java.util.Collection;
import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public final class NpcListener
implements Listener {
    @NotNull
    private final FancyHolograms plugin;

    public NpcListener(@NotNull FancyHolograms plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onRemove(@NotNull NpcRemoveEvent event) {
        this.plugin.getHologramsManager().getHolograms().stream().filter(hologram -> event.getNpc().getData().getName().equals(hologram.getData().getLinkedNpcName())).forEach(hologram -> hologram.getData().setLinkedNpcName(null));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onModify(@NotNull NpcModifyEvent event) {
        Collection<Hologram> holograms = this.plugin.getHologramsManager().getHolograms();
        switch (event.getModification()) {
            case TYPE: 
            case LOCATION: 
            case SCALE: 
            case ATTRIBUTE: {
                List<Hologram> needsToBeUpdated = holograms.stream().filter(hologram -> event.getNpc().getData().getName().equals(hologram.getData().getLinkedNpcName())).toList();
                FancyLib.getInstance().getScheduler().runTaskLater(null, 1L, () -> needsToBeUpdated.forEach(this.plugin.getHologramsManager()::syncHologramWithNpc));
                break;
            }
            case DISPLAY_NAME: 
            case SHOW_IN_TAB: {
                boolean isLinked = holograms.stream().map(Hologram::getData).map(HologramData::getLinkedNpcName).anyMatch(event.getNpc().getData().getName()::equals);
                if (!isLinked) break;
                event.setCancelled(true);
                MessageHelper.error(event.getModifier(), "This modification is not allowed on a hologram linked npc");
            }
        }
    }
}

