/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.commands.hologram;

import com.google.common.primitives.Ints;
import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.events.HologramUpdateEvent;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.commands.HologramCMD;
import de.oliver.fancyholograms.commands.Subcommand;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateTextIntervalCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        Integer interval;
        if (!player.hasPermission("fancyholograms.hologram.edit.text_interval")) {
            MessageHelper.error(player, "You don't have the required permission to edit a hologram");
            return false;
        }
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof TextHologramData)) {
            MessageHelper.error(player, "This command can only be used on text holograms");
            return false;
        }
        TextHologramData textData = (TextHologramData)hologramData;
        String text = args[3].toLowerCase(Locale.ROOT);
        if (text.equals("never") || text.equals("off") || text.equals("none")) {
            interval = -1;
        } else {
            int multiplier = 1;
            if (!text.isEmpty()) {
                switch (text.charAt(text.length() - 1)) {
                    case 's': {
                        multiplier = 1000;
                        break;
                    }
                    case 'm': {
                        multiplier = 60000;
                    }
                }
            }
            Integer time = Ints.tryParse((String)(multiplier == 1 ? text : text.substring(0, text.length() - 1)));
            interval = time == null ? null : Integer.valueOf(time * multiplier);
        }
        if (interval == null) {
            MessageHelper.error(player, "Could not parse text update interval");
            return false;
        }
        if (interval.intValue() == textData.getTextUpdateInterval()) {
            MessageHelper.warning(player, "This hologram already has this text update interval");
            return false;
        }
        interval = Math.max(-1, interval);
        TextHologramData copied = textData.copy(textData.getName());
        copied.setTextUpdateInterval(interval);
        if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.UPDATE_TEXT_INTERVAL)) {
            return false;
        }
        if (copied.getTextUpdateInterval() == textData.getTextUpdateInterval()) {
            MessageHelper.warning(player, "This hologram already has this text update interval");
            return false;
        }
        textData.setTextUpdateInterval(copied.getTextUpdateInterval());
        if (FancyHolograms.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHolograms.get().getHologramStorage().save(hologram);
        }
        MessageHelper.success(player, "Changed the text update interval");
        return true;
    }
}

