/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.commands;

import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancylib.MessageHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class FancyHologramsTestCMD
extends Command {
    @NotNull
    private final FancyHolograms plugin;

    public FancyHologramsTestCMD(@NotNull FancyHolograms plugin) {
        super("FancyHologramsTest");
        this.setPermission("fancyholograms.admin");
        this.plugin = plugin;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        if (args.length == 1) {
            return Arrays.asList("spawn100", "test1");
        }
        return Collections.emptyList();
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if (!(sender instanceof Player)) {
            MessageHelper.error(sender, "Only players can use this command!");
            return false;
        }
        Player p = (Player)sender;
        if (args.length == 1 && args[0].equalsIgnoreCase("spawn100")) {
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 10; ++j) {
                    int n = i * 10 + j + 1;
                    TextHologramData textData = new TextHologramData("holo-" + n, p.getLocation().clone().add((double)(5 * i + 1), 0.0, (double)(5 * j + 1)));
                    textData.setText(Arrays.asList("<rainbow><b>This is a test hologram! (#" + n + ")</b></rainbow>", "<red>Lorem ipsum dolor sit amet, consec tetur adipiscing elit. Donec a diam lectus. Sed sit amet ipsum mauris.", "<green>Lorem ipsum dolor sit amet, consec tetur adipiscing elit. Donec a diam lectus. Sed sit amet ipsum mauris.", "<yellow>Lorem ipsum dolor sit amet, consec tetur adipiscing elit. Donec a diam lectus. Sed sit amet ipsum mauris.", "<gradient:red:green>Lorem ipsum dolor sit amet, consec tetur adipiscing elit. Donec a diam lectus. Sed sit amet ipsum mauris.", "<gradient:green:yellow>Lorem ipsum dolor sit amet, consec tetur adipiscing elit. Donec a diam lectus. Sed sit amet ipsum mauris."));
                    textData.setTextUpdateInterval(100).setScale(new Vector3f(0.5f, 0.5f, 0.5f)).setVisibilityDistance(100);
                    Hologram hologram = this.plugin.getHologramsManager().create(textData);
                    hologram.createHologram();
                    hologram.updateShownStateFor(p);
                }
            }
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("test1")) {
            TextHologramData textData = new TextHologramData("holo-test1", p.getLocation());
            textData.setText(Arrays.asList("<rainbow><b>This is a test hologram!</b></rainbow>", "<red>Lorem ipsum dolor sit amet, consec tetur adipiscing elit. Donec a diam lectus. Sed sit amet ipsum mauris.", "<green>Lorem ipsum dolor sit amet, consec tetur adipiscing elit. Donec a diam lectus. Sed sit amet ipsum mauris.", "<yellow>Lorem ipsum dolor sit amet, consec tetur adipiscing elit. Donec a diam lectus. Sed sit amet ipsum mauris.", "<gradient:red:green>Lorem ipsum dolor sit amet, consec tetur adipiscing elit. Donec a diam lectus. Sed sit amet ipsum mauris.", "<gradient:green:yellow>Lorem ipsum dolor sit amet, consec tetur adipiscing elit. Donec a diam lectus. Sed sit amet ipsum mauris.")).setTextUpdateInterval(100).setTextAlignment(TextDisplay.TextAlignment.CENTER).setBackground(Color.fromARGB((int)15, (int)78, (int)237, (int)176)).setTextShadow(true).setScale(new Vector3f(2.0f, 2.0f, 2.0f)).setBillboard(Display.Billboard.CENTER).setBrightness(new Display.Brightness(15, 15)).setShadowRadius(3.0f).setShadowStrength(3.0f).setVisibilityDistance(100);
            Hologram hologram = this.plugin.getHologramsManager().create(textData);
            hologram.createHologram();
            hologram.updateShownStateFor(p);
        }
        return false;
    }
}

