/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.api;

import de.oliver.fancyanalytics.logger.ExtendedFancyLogger;
import de.oliver.fancyholograms.api.HologramConfiguration;
import de.oliver.fancyholograms.api.HologramManager;
import de.oliver.fancyholograms.api.HologramStorage;
import java.util.concurrent.ScheduledExecutorService;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public interface FancyHologramsPlugin {
    public static FancyHologramsPlugin get() {
        if (FancyHologramsPlugin.isEnabled()) {
            return EnabledChecker.getPlugin();
        }
        throw new NullPointerException("Plugin is not enabled");
    }

    public static boolean isEnabled() {
        return EnabledChecker.isFancyHologramsEnabled();
    }

    public JavaPlugin getPlugin();

    public ExtendedFancyLogger getFancyLogger();

    public HologramManager getHologramManager();

    public HologramConfiguration getHologramConfiguration();

    public void setHologramConfiguration(HologramConfiguration var1, boolean var2);

    public HologramStorage getHologramStorage();

    public ScheduledExecutorService getHologramThread();

    public void setHologramStorage(HologramStorage var1, boolean var2);

    public static class EnabledChecker {
        private static Boolean enabled;
        private static FancyHologramsPlugin plugin;

        public static Boolean isFancyHologramsEnabled() {
            if (enabled != null) {
                return enabled;
            }
            Plugin pl = Bukkit.getPluginManager().getPlugin("FancyHolograms");
            if (pl != null && pl.isEnabled()) {
                try {
                    plugin = (FancyHologramsPlugin)pl;
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException("API failed to access plugin, if using the FancyHolograms API make sure to set the dependency to compile only.");
                }
                enabled = true;
                return true;
            }
            return false;
        }

        public static FancyHologramsPlugin getPlugin() {
            return plugin;
        }
    }
}

