/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancysitula.versions.v26_1.packets;

import de.oliver.fancysitula.api.dialogs.FS_CommonDialogData;
import de.oliver.fancysitula.api.dialogs.FS_Dialog;
import de.oliver.fancysitula.api.dialogs.FS_DialogAction;
import de.oliver.fancysitula.api.dialogs.actions.FS_CommonButtonData;
import de.oliver.fancysitula.api.dialogs.actions.FS_DialogActionButton;
import de.oliver.fancysitula.api.dialogs.actions.FS_DialogActionButtonAction;
import de.oliver.fancysitula.api.dialogs.actions.FS_DialogCopyToClipboardAction;
import de.oliver.fancysitula.api.dialogs.actions.FS_DialogCustomAction;
import de.oliver.fancysitula.api.dialogs.body.FS_DialogBody;
import de.oliver.fancysitula.api.dialogs.body.FS_DialogItemBody;
import de.oliver.fancysitula.api.dialogs.body.FS_DialogTextBody;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogBooleanInput;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogInput;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogInputControl;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogNumberRangeInput;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogSingleOptionInput;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogTextInput;
import de.oliver.fancysitula.api.dialogs.types.FS_ConfirmationDialog;
import de.oliver.fancysitula.api.dialogs.types.FS_DialogListDialog;
import de.oliver.fancysitula.api.dialogs.types.FS_MultiActionDialog;
import de.oliver.fancysitula.api.dialogs.types.FS_NoticeDialog;
import de.oliver.fancysitula.api.entities.FS_RealPlayer;
import de.oliver.fancysitula.api.packets.FS_ClientboundShowDialogPacket;
import de.oliver.fancysitula.versions.v26_1.utils.VanillaPlayerAdapter;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundShowDialogPacket;
import net.minecraft.resources.Identifier;
import net.minecraft.server.dialog.ActionButton;
import net.minecraft.server.dialog.CommonButtonData;
import net.minecraft.server.dialog.CommonDialogData;
import net.minecraft.server.dialog.ConfirmationDialog;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.DialogAction;
import net.minecraft.server.dialog.DialogListDialog;
import net.minecraft.server.dialog.Input;
import net.minecraft.server.dialog.MultiActionDialog;
import net.minecraft.server.dialog.NoticeDialog;
import net.minecraft.server.dialog.action.CustomAll;
import net.minecraft.server.dialog.action.StaticAction;
import net.minecraft.server.dialog.body.DialogBody;
import net.minecraft.server.dialog.body.ItemBody;
import net.minecraft.server.dialog.body.PlainMessage;
import net.minecraft.server.dialog.input.BooleanInput;
import net.minecraft.server.dialog.input.InputControl;
import net.minecraft.server.dialog.input.NumberRangeInput;
import net.minecraft.server.dialog.input.SingleOptionInput;
import net.minecraft.server.dialog.input.TextInput;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class ClientboundShowDialogPacketImpl
extends FS_ClientboundShowDialogPacket {
    public ClientboundShowDialogPacketImpl(FS_Dialog dialog) {
        super(dialog);
    }

    @Override
    public Object createPacket() {
        Holder holder = Holder.direct((Object)this.toNms(this.dialog));
        return new ClientboundShowDialogPacket(holder);
    }

    @Override
    protected void sendPacketTo(FS_RealPlayer player) {
        ClientboundShowDialogPacket packet = (ClientboundShowDialogPacket)this.createPacket();
        ServerPlayer vanillaPlayer = VanillaPlayerAdapter.asVanilla(player.getBukkitPlayer());
        vanillaPlayer.connection.send((Packet)packet);
    }

    private Dialog toNms(FS_Dialog dialog) {
        if (dialog instanceof FS_NoticeDialog) {
            FS_NoticeDialog notice = (FS_NoticeDialog)dialog;
            return this.noticeToNms(notice);
        }
        if (dialog instanceof FS_ConfirmationDialog) {
            FS_ConfirmationDialog confirmation = (FS_ConfirmationDialog)dialog;
            return this.confirmationToNms(confirmation);
        }
        if (dialog instanceof FS_DialogListDialog) {
            FS_DialogListDialog dialogList = (FS_DialogListDialog)dialog;
            return this.dialogListToNms(dialogList);
        }
        if (dialog instanceof FS_MultiActionDialog) {
            FS_MultiActionDialog multiActionDialog = (FS_MultiActionDialog)dialog;
            return this.multiActionDialogToNms(multiActionDialog);
        }
        return null;
    }

    private Dialog noticeToNms(FS_NoticeDialog notice) {
        CommonDialogData common = this.commonToNms(notice.getDialogData());
        ActionButton actionButton = this.actionButtonToNms(notice.getActionButton());
        return new NoticeDialog(common, actionButton);
    }

    private Dialog confirmationToNms(FS_ConfirmationDialog notice) {
        CommonDialogData common = this.commonToNms(notice.getDialogData());
        ActionButton yes = this.actionButtonToNms(notice.getYesButton());
        ActionButton no = this.actionButtonToNms(notice.getNoButton());
        return new ConfirmationDialog(common, yes, no);
    }

    private Dialog dialogListToNms(FS_DialogListDialog dialogList) {
        CommonDialogData common = this.commonToNms(dialogList.getDialogData());
        ArrayList<Holder> dialogs = new ArrayList<Holder>();
        for (FS_Dialog dialog : dialogList.getDialogs()) {
            dialogs.add(Holder.direct((Object)this.toNms(dialog)));
        }
        HolderSet.Direct dialogSet = HolderSet.direct(dialogs);
        Optional exitButton = dialogList.getExitButton() != null ? Optional.of(this.actionButtonToNms(dialogList.getExitButton())) : Optional.empty();
        return new DialogListDialog(common, (HolderSet)dialogSet, exitButton, dialogList.getColumns(), dialogList.getButtonWidth());
    }

    private Dialog multiActionDialogToNms(FS_MultiActionDialog multiActionDialog) {
        CommonDialogData common = this.commonToNms(multiActionDialog.getDialogData());
        ArrayList<ActionButton> actionButtons = new ArrayList<ActionButton>();
        for (FS_DialogActionButton actionButton : multiActionDialog.getActions()) {
            actionButtons.add(this.actionButtonToNms(actionButton));
        }
        Optional exitAction = multiActionDialog.getExitAction() != null ? Optional.of(this.actionButtonToNms(multiActionDialog.getExitAction())) : Optional.empty();
        return new MultiActionDialog(common, actionButtons, exitAction, multiActionDialog.getColumns());
    }

    private CommonDialogData commonToNms(FS_CommonDialogData dialogData) {
        net.minecraft.network.chat.Component title = PaperAdventure.asVanilla((Component)MiniMessage.miniMessage().deserialize((Object)dialogData.getTitle()));
        Optional externalTitle = dialogData.getExternalTitle() != null ? Optional.of(PaperAdventure.asVanilla((Component)MiniMessage.miniMessage().deserialize((Object)dialogData.getExternalTitle()))) : Optional.empty();
        return new CommonDialogData(title, externalTitle, dialogData.isCanCloseWithEscape(), dialogData.isPause(), this.actionToNms(dialogData.getAfterAction()), this.bodyToNms(dialogData.getBody()), this.inputsToNms(dialogData.getInputs()));
    }

    private DialogAction actionToNms(FS_DialogAction dialogAction) {
        return switch (dialogAction) {
            default -> throw new MatchException(null, null);
            case FS_DialogAction.CLOSE -> DialogAction.CLOSE;
            case FS_DialogAction.NONE -> DialogAction.NONE;
            case FS_DialogAction.WAIT_FOR_RESPONSE -> DialogAction.WAIT_FOR_RESPONSE;
        };
    }

    private List<DialogBody> bodyToNms(List<FS_DialogBody> bodies) {
        ArrayList<DialogBody> nmsBodies = new ArrayList<DialogBody>();
        for (FS_DialogBody body : bodies) {
            if (body instanceof FS_DialogTextBody) {
                FS_DialogTextBody textBody = (FS_DialogTextBody)body;
                nmsBodies.add((DialogBody)new PlainMessage(PaperAdventure.asVanilla((Component)MiniMessage.miniMessage().deserialize((Object)textBody.getText())), textBody.getWidth()));
                continue;
            }
            if (!(body instanceof FS_DialogItemBody)) continue;
            FS_DialogItemBody itemBody = (FS_DialogItemBody)body;
            Optional description = itemBody.getDescription() != null ? Optional.of(new PlainMessage(PaperAdventure.asVanilla((Component)MiniMessage.miniMessage().deserialize((Object)itemBody.getDescription().getText())), itemBody.getDescription().getWidth())) : Optional.empty();
            nmsBodies.add((DialogBody)new ItemBody(CraftItemStack.asNMSCopy((ItemStack)itemBody.getItem()), description, itemBody.isShowDecorations(), itemBody.isShowTooltip(), itemBody.getWidth(), itemBody.getHeight()));
        }
        return nmsBodies;
    }

    private List<Input> inputsToNms(List<FS_DialogInput> inputs) {
        ArrayList<Input> nmsInputs = new ArrayList<Input>();
        for (FS_DialogInput input : inputs) {
            String key = input.getKey();
            BooleanInput control = null;
            FS_DialogInputControl fS_DialogInputControl = input.getControl();
            if (fS_DialogInputControl instanceof FS_DialogBooleanInput) {
                FS_DialogBooleanInput booleanInput = (FS_DialogBooleanInput)fS_DialogInputControl;
                control = new BooleanInput(PaperAdventure.asVanilla((Component)MiniMessage.miniMessage().deserialize((Object)booleanInput.getLabel())), booleanInput.isInitial(), booleanInput.getOnTrue(), booleanInput.getOnFalse());
            } else {
                fS_DialogInputControl = input.getControl();
                if (fS_DialogInputControl instanceof FS_DialogNumberRangeInput) {
                    FS_DialogNumberRangeInput numberRangeInput = (FS_DialogNumberRangeInput)fS_DialogInputControl;
                    control = new NumberRangeInput(numberRangeInput.getWidth(), PaperAdventure.asVanilla((Component)MiniMessage.miniMessage().deserialize((Object)numberRangeInput.getLabel())), numberRangeInput.getLabelFormat(), new NumberRangeInput.RangeInfo(numberRangeInput.getStart(), numberRangeInput.getEnd(), numberRangeInput.getInitial() != null ? Optional.of(numberRangeInput.getInitial()) : Optional.empty(), numberRangeInput.getStep() != null ? Optional.of(numberRangeInput.getStep()) : Optional.empty()));
                } else {
                    fS_DialogInputControl = input.getControl();
                    if (fS_DialogInputControl instanceof FS_DialogSingleOptionInput) {
                        FS_DialogSingleOptionInput singleOptionInput = (FS_DialogSingleOptionInput)fS_DialogInputControl;
                        ArrayList<SingleOptionInput.Entry> nmsEntries = new ArrayList<SingleOptionInput.Entry>();
                        for (FS_DialogSingleOptionInput.Entry entry : singleOptionInput.getEntries()) {
                            nmsEntries.add(new SingleOptionInput.Entry(entry.getId(), entry.getDisplay() != null ? Optional.of(PaperAdventure.asVanilla((Component)MiniMessage.miniMessage().deserialize((Object)entry.getDisplay()))) : Optional.empty(), entry.isInitial()));
                        }
                        control = new SingleOptionInput(singleOptionInput.getWidth(), nmsEntries, PaperAdventure.asVanilla((Component)MiniMessage.miniMessage().deserialize((Object)singleOptionInput.getLabel())), singleOptionInput.isLabelVisible());
                    } else {
                        fS_DialogInputControl = input.getControl();
                        if (fS_DialogInputControl instanceof FS_DialogTextInput) {
                            FS_DialogTextInput textInput = (FS_DialogTextInput)fS_DialogInputControl;
                            control = new TextInput(textInput.getWidth(), PaperAdventure.asVanilla((Component)MiniMessage.miniMessage().deserialize((Object)textInput.getLabel())), textInput.isLabelVisible(), textInput.getInitial(), textInput.getMaxLength(), Optional.empty());
                        }
                    }
                }
            }
            nmsInputs.add(new Input(key, (InputControl)control));
        }
        return nmsInputs;
    }

    private ActionButton actionButtonToNms(FS_DialogActionButton actionButton) {
        CommonButtonData buttonData = this.commonButtonDataToNms(actionButton.getButtonData());
        StaticAction action = null;
        FS_DialogActionButtonAction fS_DialogActionButtonAction = actionButton.getAction();
        if (fS_DialogActionButtonAction instanceof FS_DialogCopyToClipboardAction) {
            FS_DialogCopyToClipboardAction copyToClipboardAction = (FS_DialogCopyToClipboardAction)fS_DialogActionButtonAction;
            clickEvent = new ClickEvent.CopyToClipboard(copyToClipboardAction.getValue());
            action = new StaticAction((ClickEvent)clickEvent);
        } else {
            clickEvent = actionButton.getAction();
            if (clickEvent instanceof FS_DialogCustomAction) {
                Optional<Object> additions;
                FS_DialogCustomAction customAction = (FS_DialogCustomAction)clickEvent;
                Key idKey = Key.key((String)"fancysitula", (String)customAction.getId());
                Identifier idLocation = PaperAdventure.asVanilla((Key)idKey);
                if (customAction.getAdditions() != null) {
                    CompoundTag tag = new CompoundTag();
                    customAction.getAdditions().forEach((arg_0, arg_1) -> ((CompoundTag)tag).putString(arg_0, arg_1));
                    additions = Optional.of(tag);
                } else {
                    additions = Optional.empty();
                }
                action = new CustomAll(idLocation, additions);
            }
        }
        Optional<Object> optionalAction = action != null ? Optional.of(action) : Optional.empty();
        return new ActionButton(buttonData, optionalAction);
    }

    private CommonButtonData commonButtonDataToNms(FS_CommonButtonData commonButtonData) {
        net.minecraft.network.chat.Component label = PaperAdventure.asVanilla((Component)MiniMessage.miniMessage().deserialize((Object)commonButtonData.getLabel()));
        Optional tooltip = commonButtonData.getTooltip() != null ? Optional.of(PaperAdventure.asVanilla((Component)MiniMessage.miniMessage().deserialize((Object)commonButtonData.getTooltip()))) : Optional.empty();
        int width = commonButtonData.getWidth();
        return new CommonButtonData(label, tooltip, width);
    }
}

