/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.api.data;

import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DialogButton {
    private final String label;
    private final String tooltip;
    private final List<DialogAction> actions;
    private transient String id = UUID.randomUUID().toString();
    private final Map<String, String> requirements;
    private final Integer width;

    public DialogButton(String label, String tooltip, List<DialogAction> actions, Map<String, String> requirements, int width) {
        this.label = label;
        this.tooltip = tooltip;
        this.actions = actions;
        this.requirements = Map.copyOf(requirements);
        this.width = width;
    }

    public String id() {
        if (this.id == null || this.id.isEmpty()) {
            this.id = UUID.randomUUID().toString();
        }
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public String tooltip() {
        return this.tooltip;
    }

    public Map<String, String> requirements() {
        return this.requirements;
    }

    public List<DialogAction> actions() {
        return this.actions;
    }

    public Integer width() {
        return this.width;
    }

    public record DialogAction(String name, String data) {
    }
}

