/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.api;

import com.fancyinnovations.fancydialogs.api.data.DialogData;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

public abstract class Dialog {
    protected String id;
    protected DialogData data;
    protected Map<UUID, Long> viewers;

    public Dialog(String id, DialogData data) {
        this.id = id;
        this.data = data;
        this.viewers = new ConcurrentHashMap<UUID, Long>();
    }

    public Dialog() {
    }

    public abstract void open(Player var1);

    public abstract void open(Player var1, String ... var2);

    public abstract void close(Player var1);

    public String getId() {
        return this.id;
    }

    public DialogData getData() {
        return this.data;
    }

    public Set<UUID> getViewers() {
        return Set.copyOf(this.viewers.keySet());
    }

    public abstract boolean isOpenedFor(UUID var1);

    public boolean isOpenedFor(Player player) {
        if (player == null) {
            return false;
        }
        return this.isOpenedFor(player.getUniqueId());
    }

    @ApiStatus.Internal
    public void addViewer(Player player) {
        if (player == null) {
            return;
        }
        this.viewers.put(player.getUniqueId(), System.currentTimeMillis());
    }

    @ApiStatus.Internal
    public void removeViewer(Player player) {
        if (player == null) {
            return;
        }
        this.viewers.remove(player.getUniqueId());
    }
}

