/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.jdb;

import com.google.gson.annotations.SerializedName;
import de.oliver.jdb.JDB;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public record JIndex(String name, @SerializedName(value="base_path") String basePath, @SerializedName(value="index_map") Map<String, String> indexMap) {
    public static JIndex load(String name, String basePath) {
        JIndex jIndex;
        block9: {
            File indexFile = new File(basePath, name + ".json");
            if (!indexFile.exists()) {
                return new JIndex(name, basePath, new ConcurrentHashMap<String, String>());
            }
            BufferedReader reader = Files.newBufferedReader(indexFile.toPath());
            try {
                jIndex = JDB.GSON.fromJson((Reader)reader, JIndex.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new JIndex(name, basePath, new ConcurrentHashMap<String, String>());
                }
            }
            reader.close();
        }
        return jIndex;
    }

    public void save() {
        File indexFile = new File(this.basePath, this.name + ".json");
        String json = JDB.GSON.toJson(this);
        try {
            Files.write(indexFile.toPath(), json.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

