/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.api.dialogs;

import com.fancyinnovations.fancydialogs.api.Dialog;
import com.fancyinnovations.fancydialogs.api.FancyDialogs;
import com.fancyinnovations.fancydialogs.api.data.DialogBodyData;
import com.fancyinnovations.fancydialogs.api.data.DialogButton;
import com.fancyinnovations.fancydialogs.api.data.DialogData;
import com.fancyinnovations.fancydialogs.api.data.inputs.DialogInputs;
import com.fancyinnovations.fancydialogs.api.data.inputs.DialogTextField;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class ConfirmationDialog {
    public static final Map<String, ConfirmationDialog> CACHE = new ConcurrentHashMap<String, ConfirmationDialog>();
    private final String question;
    private String title = "Confirmation";
    private String confirmText = "Yes";
    private String cancelText = "No";
    private String expectedUserInput = "";
    private Dialog dialog;
    private String confirmButtonId;
    private String cancelButtonId;
    private Runnable onConfirm;
    private Runnable onCancel;

    public ConfirmationDialog(String title, String question, String confirmText, String cancelText, String expectedUserInput, Runnable onConfirm, Runnable onCancel) {
        this.onConfirm = () -> {};
        this.onCancel = () -> {};
        this.title = title;
        this.question = question;
        this.confirmText = confirmText;
        this.cancelText = cancelText;
        this.onConfirm = onConfirm;
        this.onCancel = onCancel;
    }

    public ConfirmationDialog(String question) {
        this.onConfirm = () -> {};
        this.onCancel = () -> {};
        this.question = question;
    }

    public ConfirmationDialog withTitle(String title) {
        this.title = title;
        return this;
    }

    public ConfirmationDialog withConfirmText(String confirmText) {
        this.confirmText = confirmText;
        return this;
    }

    public ConfirmationDialog withCancelText(String cancelText) {
        this.cancelText = cancelText;
        return this;
    }

    public ConfirmationDialog withExpectedUserInput(String expectedUserInput) {
        this.expectedUserInput = expectedUserInput;
        return this;
    }

    public ConfirmationDialog withOnConfirm(Runnable onConfirm) {
        this.onConfirm = onConfirm;
        return this;
    }

    public ConfirmationDialog withOnCancel(Runnable onCancel) {
        this.onCancel = onCancel;
        return this;
    }

    public void ask(Player player) {
        this.buildDialog();
        this.dialog.open(player);
        CACHE.put(this.dialog.getId(), this);
    }

    private void buildDialog() {
        if (this.title == null || this.title.isEmpty()) {
            this.title = "Confirmation";
        }
        if (this.confirmText == null || this.confirmText.isEmpty()) {
            this.confirmText = "Yes";
        }
        if (this.cancelText == null || this.cancelText.isEmpty()) {
            this.cancelText = "No";
        }
        DialogButton confirmBtn = new DialogButton(this.confirmText, this.confirmText, List.of(new DialogButton.DialogAction("confirm", "")), Map.of("", ""));
        this.confirmButtonId = confirmBtn.id();
        DialogButton cancelBtn = new DialogButton(this.cancelText, this.cancelText, List.of(new DialogButton.DialogAction("cancel", "")), Map.of("", ""));
        this.cancelButtonId = cancelBtn.id();
        List<DialogTextField> textFields = null;
        if (this.expectedUserInput != null && !this.expectedUserInput.isEmpty()) {
            textFields = List.of(new DialogTextField("confirmation_user_input", "Type '" + this.expectedUserInput + "' to confirm", 0, "", this.expectedUserInput.length(), 1, Map.of("type", "")));
        }
        DialogInputs inputs = new DialogInputs(textFields, null, null);
        DialogData dialogData = new DialogData("confirmation_dialog_" + String.valueOf(UUID.randomUUID()), this.title, false, List.of(new DialogBodyData(this.question)), inputs, List.of(confirmBtn, cancelBtn));
        this.dialog = FancyDialogs.get().createDialog(dialogData);
    }

    public String getExpectedUserInput() {
        return this.expectedUserInput;
    }

    public String getConfirmButtonId() {
        return this.confirmButtonId;
    }

    public String getCancelButtonId() {
        return this.cancelButtonId;
    }

    public Runnable getOnConfirm() {
        return this.onConfirm;
    }

    public Runnable getOnCancel() {
        return this.onCancel;
    }
}

